package de.fzi.kamp.ui.workorganisation;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.viewers.TreeViewer;

import de.fzi.maintainabilitymodel.main.MainPackage;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;

public class WorkorganisationAdapter extends EContentAdapter {

    private final static Logger logger = Logger.getLogger(WorkorganisationAdapter.class);

    private TreeViewer treeViewer;

    public WorkorganisationAdapter(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    @Override
    public void notifyChanged(Notification notification) {
        if (notification.getFeatureID(MaintainabilityAnalysisModel.class) == MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__WORKORGANISATION) {

            update();
        }

        super.notifyChanged(notification);

    }

    private void update() {
        this.treeViewer.refresh();
    }
}
