package de.fzi.kamp.ui.preparation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;

public class RemoveChangeRequestListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(RemoveChangeRequestListener.class);

    private AnalysisManager manager;
    private Table table;

    public RemoveChangeRequestListener(Table table, AnalysisManager manager) {
        super();

        this.table = table;
        this.manager = manager;
    }

    public void widgetSelected(SelectionEvent e) {

        TableItem[] item = table.getSelection();
        if (item.length > 0)
            manager.getPreparationManager().removeChangeRequest((ChangeRequest) item[0].getData());
    }
}
