package de.fzi.kamp.ui.preparation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;

import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;

public class RemoveArchitectureListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(RemoveArchitectureListener.class);

    private Table table;
    private AnalysisManager manager;

    public RemoveArchitectureListener(AnalysisManager manager, Table table) {
        super();
        this.table = table;
        this.manager = manager;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.table.getSelectionIndex() >= 0) {
            int selectedIndex = table.getSelectionIndex();
            ArchitecturalAlternative selectedAlternative = manager.getPreparationManager()
                    .getArchitectureAlternatives().get(selectedIndex);
            manager.getPreparationManager().removeArchitectureAlternative(selectedAlternative);
        }
    }
}
