package de.fzi.kamp.ui.preparation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;

public class EditChangeRequestListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(EditChangeRequestListener.class);

    private AnalysisManager manager;
    private Table table;

    public EditChangeRequestListener(Table table, AnalysisManager manager) {
        super();

        this.manager = manager;
        this.table = table;
    }

    public void widgetSelected(SelectionEvent e) {

        TableItem[] item = table.getSelection();
        if (item.length > 0)
            manager.getPreparationManager().editChangeRequest((ChangeRequest) item[0].getData());

    }
}
