package de.fzi.kamp.ui.preparation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;

public class EditAlternativeListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(EditAlternativeListener.class);

    private Table table;
    private AnalysisManager manager;

    public EditAlternativeListener(Table table, AnalysisManager manager) {
        super();

        this.table = table;
        this.manager = manager;
    }

    public void widgetSelected(SelectionEvent e) {

        TableItem[] item = table.getSelection();
        if (item.length > 0)
            manager.getPreparationManager().editArchitectureAlternative((ArchitecturalAlternative) item[0].getData());
        table.update();

    }
}
