package de.fzi.kamp.ui.preparation.dialogs;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import de.fzi.maintainabilitymodel.workplan.ChangeRequest;

/**
 * This dialog opens if the user clicks the "Add" button in the change request section of the
 * preparation page.
 * 
 * @author tknapp
 * 
 */
public class AddChangeRequestDialog extends Dialog {

    private final static Logger logger = Logger.getLogger(AddChangeRequestDialog.class);

    private ChangeRequest changeRequest;
    private Composite area;
    private Text textName;
    private Text textDescription;
    private Label nameLabel;
    private Label descriptionLabel;
    private boolean edit;
    private Button checkboxforZeroModel;

    public AddChangeRequestDialog(Shell parentShell, ChangeRequest changeRequest, boolean edit) {
        super(parentShell);
        this.changeRequest = changeRequest;
        this.edit = edit;
    }

    /**
     * Here the position and the size of the dialog are determined. The size is fix, but the
     * position is the current position of the mouse courser.
     */
    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (!edit)
            shell.setText("Add Change Request");
        else
            shell.setText("Edit Change Request");

        // center the shell and set width and height
        Point curserPosition = shell.getDisplay().getCursorLocation();
        int shellWidth = 280;
        int shellHeight = 180;
        int indentionLeft = curserPosition.x;
        int indentionTop = curserPosition.y;
        shell.setBounds(indentionLeft, indentionTop, shellWidth, shellHeight);
    }

    /**
     * Creates the different elements of the dialog.
     */
    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);

        this.area = (Composite) this.getDialogArea();
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.area.setLayout(gl);

        createNamePart();
        createDescriptionPart();
        createCheckboxForZeroModel();

        return control;
    }

    /**
     * If the OK-button is pressed, the delivered change request is filled with the information
     * given by the user.
     */
    protected void okPressed() {
        String name = this.textName.getText();
        String description = this.textDescription.getText();

        if ((name != null) && !name.isEmpty()) {
            this.changeRequest.setName(name);
            this.changeRequest.setDescription(description);
            if (this.checkboxforZeroModel.getSelection()) {
                this.changeRequest.setAutomaticDerivation(true);
                logger.debug("Automated derivation activated.");
            }
            super.okPressed();
        }
    }

    /**
     * Creates the text area to insert the name of the change request.
     */
    protected void createNamePart() {

        nameLabel = new Label(area, SWT.NONE);
        nameLabel.setText("Name: ");
        this.textName = new Text(area, SWT.SINGLE | SWT.BORDER);
        this.textName.setText(changeRequest.getName());

        GridData gd = new GridData();
        gd.horizontalAlignment = SWT.FILL;
        gd.grabExcessHorizontalSpace = true;
        this.textName.setLayoutData(gd);

    }

    /**
     * Creates the text area to insert the description of the change request.
     */
    protected void createDescriptionPart() {

        descriptionLabel = new Label(area, SWT.NONE);
        descriptionLabel.setText("Description: ");
        this.textDescription = new Text(area, SWT.SINGLE | SWT.BORDER);
        this.textDescription.setText(changeRequest.getDescription());

        GridData gd = new GridData();
        gd.horizontalAlignment = SWT.FILL;
        gd.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData(gd);
    }

    /**
     * Actually this checkbox exists to mark whether an change request is the comparison to the
     * empty zero-model, but it has to be checked whether this is the right place to do this. TODO:
     * Check this!
     */
    private void createCheckboxForZeroModel() {
        Composite wrapper = new Composite(this.area, SWT.NONE);

        this.checkboxforZeroModel = new Button(wrapper, SWT.CHECK);
        this.checkboxforZeroModel.setText("Automated workplan derivation");

        Button helpButton = new Button(wrapper, SWT.NONE);
        helpButton.setImage(getShell().getDisplay().getSystemImage(SWT.ICON_QUESTION));// Activator.getImageDescriptor("/icons/questionmark.gif").createImage());

        wrapper.setLayout(new GridLayout(2, false));
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        wrapper.setLayoutData(layoutData);

        helpButton.addSelectionListener(new SelectionAdapter() {

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                widgetSelected(e);
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(getShell());
                messageBox.setText("Information");
                messageBox.setMessage("Check this box if you want to create an workplan automatically "
                        + "from the difference of two models.");
                messageBox.open();
            }
        });
    }
}
