package de.fzi.kamp.ui.preparation.adapter;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.maintainabilitymodel.main.MainPackage;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;

public class ChangeRequestContentAdapter extends EContentAdapter {

    private final static Logger logger = Logger.getLogger(ChangeRequestContentAdapter.class);

    private Table table;
    private MaintainabilityAnalysisModel analysisModel;

    public ChangeRequestContentAdapter(Table table, MaintainabilityAnalysisModel analysisModel) {
        super();
        this.table = table;
        this.analysisModel = analysisModel;

        update();
    }

    @Override
    public void notifyChanged(Notification notification) {

        if (notification.getFeatureID(MaintainabilityAnalysisModel.class) == MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__CHANGEREQUESTS) {
            update();
        }
        super.notifyChanged(notification);
    }

    private void update() {
        table.removeAll();

        for (ChangeRequest changeRequest : analysisModel.getChangerequests()) {
            TableItem item = new TableItem(table, SWT.NONE);
            String[] content = new String[3];
            content[0] = changeRequest.getName();
            content[1] = changeRequest.getDescription();
            if (changeRequest.isAutomaticDerivation()) {
                content[2] = "YES";
            } else {
                content[2] = "NO";
            }
            item.setText(content);
            item.setData(changeRequest);
            item.setFont(SurfaceFactory.getFontStyle().get("answerStyle"));
        }
        table.getColumn(0).pack();
    }
}
