package de.fzi.kamp.ui.preparation.adapter;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.maintainabilitymodel.main.MainPackage;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;

public class ArchitectureAlternativesContentAdapter extends EContentAdapter {

    private final static Logger logger = Logger.getLogger(ArchitectureAlternativesContentAdapter.class);

    private Table table;
    private MaintainabilityAnalysisModel analysisModel;

    public ArchitectureAlternativesContentAdapter(Table table, MaintainabilityAnalysisModel analysisModel) {
        super();
        this.table = table;
        this.analysisModel = analysisModel;

        update();
    }

    @Override
    public void notifyChanged(Notification notification) {
        if (notification.getFeatureID(MaintainabilityAnalysisModel.class) == MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREALTERNATIVES) {
            update();
        }
        super.notifyChanged(notification);
    }

    private void update() {
        this.table.removeAll();

        for (ArchitecturalAlternative alternative : analysisModel.getArchitecturealternatives()) {
            TableItem item = new TableItem(this.table, SWT.NONE);

            item.setText(new String[] { alternative.getName(), alternative.getDescription() });
            item.setData(alternative);

            item.setFont(SurfaceFactory.getFontStyle().get(SurfaceFactory.STYLE_ANSWER));
        }

        for (TableColumn column : this.table.getColumns()) {
            column.pack();
        }
    }
}
