package de.fzi.kamp.ui.maineditor.stacklayers;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;

import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.general.ActivityImageProvider;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.maineditor.page.CentralEditorPage;
import de.fzi.kamp.ui.workplanediting.adapter.WorkPlanContentAdapter;
import de.fzi.kamp.ui.workplanediting.listeners.AddTopLevelActivitiesListener;
import de.fzi.kamp.ui.workplanediting.listeners.BackToAnalysisOverviewPageListener;
import de.fzi.kamp.ui.workplanediting.listeners.ContextMenuMouseListenerForWorkplanTree;
import de.fzi.kamp.ui.workplanediting.listeners.DeveloperStructureButtonListener;
import de.fzi.kamp.ui.workplanediting.listeners.LowestAbstractionListener;
import de.fzi.kamp.ui.workplanediting.listeners.WorkplanContainmentButtonListener;
import de.fzi.kamp.ui.workplanediting.listeners.WorkplanFollowUpButtonListener;
import de.fzi.kamp.ui.workplanediting.provider.WorkplanTableColumnConstants;

public class WorkplanTableLayer {

    private final static Logger logger = Logger.getLogger(WorkplanTableLayer.class);

    private List<Widget> widgets;
    
    private static final String BUTTONTEXT_LOWESTABSTRACTIONLEVEL = "Lowest Abstraction Level";
    private static final String BUTTONTEXT_DEVELOPERSTRUCTURE = "Developer Structure";
    private static final String BUTTONTEXT_CONTAINMENTRELATION = "Containment Relation";
    private static final String BUTTONTEXT_FOLLOW_UP_RELATION = "Follow-Up Relation";
    private static final String BUTTONTEXT_NAVIGATIONBUTTON = "Go back to Analysis Overview";
    private static final String BUTTONTEXT_ADDCHANGINGDOMAIN = "Add Composite Activity / Milestone";
    private static final String BUTTONTEXT_CALCULATE_FOLLOWUPS = "Calculate follow-ups";
    private static final String GROUPHEADING_RELATIONGROUP = "Show Activities in";

    private CentralEditorPage page;
    private WorkPlanContentAdapter adapter;
    private Display display;
    private boolean isEditableEffort;
    private ScrolledForm form;
    private Composite structureButtons;
    private IMainEditor mainEditor;
    private Group groupForButtons;
    private Button addCompositeButton;
    //private Button calculateFollowUpsButton;
    private Tree tree;
    
    private SurfaceFactory factory = new SurfaceFactory();

    public WorkplanTableLayer(CentralEditorPage page) {
        this.page = page;
        disposeWidgets();
    }

    public void disposeWidgets() {
        if (this.widgets != null && !this.widgets.isEmpty()) {
            for (Widget widget : this.widgets) {
                if (!widget.isDisposed())
                    widget.dispose();
            }
        }
        this.widgets = new ArrayList<Widget>();
    }
    
    
    public void createWorkplanTable(Display display, IMainEditor mainEditor, ScrolledForm form) {

        this.display = display;
        this.form = form;
        this.mainEditor = mainEditor;

        String[] headings = WorkplanTableColumnConstants.getHeadings();
        this.tree = factory.createTreeforEclipseForm(display, this.form.getBody(), headings, TableWrapData.FILL, true,
                1, 450);
        this.tree.getColumn(WorkplanTableColumnConstants.COLUMN_ISSIGNATURECHANGE).setAlignment(SWT.CENTER);
        this.widgets.add(tree);
        
        this.groupForButtons = new Group(this.form.getBody(), SWT.NONE);
        this.widgets.add(groupForButtons);
        
        factory.configureCompositeForTableWrapLayout(groupForButtons, 3, TableWrapData.LEFT, 1, false, 
                factory.lookupColor(display, 255, 255, 255, "white"));
        this.adapter = new WorkPlanContentAdapter(tree, this.mainEditor);
        createGroupForButtons(display, mainEditor);
        showEffortEstimationColumns();

        // analysisManager.getAnalysisModel().eAdapters().add(adapter);

        tree.addMouseListener(new ContextMenuMouseListenerForWorkplanTree(tree, mainEditor));
    }

    private void createGroupForButtons(Display display, IMainEditor mainEditor) {
//        CalculateFollowUpActivitiesListener calculateFollowUpListener = new CalculateFollowUpActivitiesListener(
//                mainEditor, this.tree);

        //Calculate follow up button has been removed. Can be added by inserting calculateFollowUpListener()
        //and by adding the BUTTONTEXT_CALCULATE_FOLLOWUPS constant. 
        SelectionAdapter[] navigationListeners = { new BackToAnalysisOverviewPageListener(mainEditor),
                new AddTopLevelActivitiesListener(mainEditor, tree)};
        factory.createButtonsForGivenTableWrapComposite(this.groupForButtons, new String[] {
                BUTTONTEXT_NAVIGATIONBUTTON, BUTTONTEXT_ADDCHANGINGDOMAIN},
                TableWrapData.FILL, SWT.NONE, true, navigationListeners,
                new Image[]{ActivityImageProvider.getArrowLeftIcon(), ActivityImageProvider.getIconForAddButton()});

        Control[] buttons = this.groupForButtons.getChildren();
        this.addCompositeButton = (Button) buttons[1];
        //this.calculateFollowUpsButton = (Button) buttons[2];
        for (Control button : buttons)
            this.widgets.add(button);
    }

    public WorkPlanContentAdapter getAdapter() {
        return this.adapter;
    }

    private Composite createSelectStructureComposite() {

        FormToolkit toolkit = new FormToolkit(display);

        Group group = factory.createGroupWithWhiteBackgroundTableWrap(display, this.form.getBody(),
                GROUPHEADING_RELATIONGROUP, TableWrapData.RIGHT, false, 1, 4);
        group.setFont(SurfaceFactory.getFontStyle().getBold(SurfaceFactory.STYLE_GROUP));

        this.widgets.add(group);
        
        if (!isEditableEffort) {
            Button containment = toolkit.createButton(group, BUTTONTEXT_CONTAINMENTRELATION, SWT.RADIO);
            containment.addSelectionListener(new WorkplanContainmentButtonListener(this.page, this.tree));
            containment.setSelection(true);

            Button followUp = toolkit.createButton(group, BUTTONTEXT_FOLLOW_UP_RELATION, SWT.RADIO);
            followUp.addSelectionListener(new WorkplanFollowUpButtonListener(this.page, this.tree));
            
            this.widgets.add(containment);
            this.widgets.add(followUp);
        } else {
            Button lowestAbstractionButton = toolkit.createButton(group, BUTTONTEXT_LOWESTABSTRACTIONLEVEL, SWT.CHECK);
            Button isDeveloperStructureButton = toolkit.createButton(group, BUTTONTEXT_DEVELOPERSTRUCTURE, SWT.CHECK);

            lowestAbstractionButton.addSelectionListener(new LowestAbstractionListener(this.page, this.tree,
                    lowestAbstractionButton, isDeveloperStructureButton));
            isDeveloperStructureButton.addSelectionListener(new DeveloperStructureButtonListener(mainEditor, tree,
                    isDeveloperStructureButton));
            this.widgets.add(lowestAbstractionButton);
            this.widgets.add(isDeveloperStructureButton);
        }

        return group;
    }

    public void showEffortEstimationColumns() {

        if (this.structureButtons != null) {
            this.structureButtons.dispose();
        }

        this.structureButtons = createSelectStructureComposite();
        if (!this.tree.isDisposed()) {
            this.structureButtons.moveAbove(this.tree);
            form.reflow(true);
        }
    }

    public void setIsEditableEffort(boolean isEditableEffort) {
        this.isEditableEffort = isEditableEffort;
    }

    public void setAddActivityAndCalcFollowUpsButtonsINVISIBLE() {
//        this.calculateFollowUpsButton.setEnabled(false);
//        this.calculateFollowUpsButton.setGrayed(false);

        if (!this.addCompositeButton.isDisposed()) {
            this.addCompositeButton.setEnabled(false);
            this.addCompositeButton.setGrayed(true);
        }
    }

    public void setAddActivityAndCalcFollowUpsButtonsVISIBLE() {
//        this.calculateFollowUpsButton.setEnabled(true);
//        this.calculateFollowUpsButton.setGrayed(true);

        if (!this.addCompositeButton.isDisposed()) {
            this.addCompositeButton.setEnabled(true);
            this.addCompositeButton.setGrayed(false);
        }
    }

    public void showDeveloperOrLowestAbstactionStructureView(Boolean showDeveloper) {
        if (showDeveloper) {
            tree.getColumn(WorkplanTableColumnConstants.COLUMN_DEVELOPERSTRUCTURE).pack();
            tree.getColumn(WorkplanTableColumnConstants.COLUMN_DEVELOPERSTRUCTURE).setResizable(true);
        } else {
            for (TreeColumn column : tree.getColumns()) {
                if ((column.getText() == WorkplanTableColumnConstants.CAPTION_COLUMN_DEVELOPERSTRUCTURE
                        || column.getText() == WorkplanTableColumnConstants.CAPTION_COLUMN_COMPONENT
                        || column.getText() == WorkplanTableColumnConstants.CAPTION_COLUMN_INTERFACEPORT || column
                        .getText() == WorkplanTableColumnConstants.CAPTION_COLUMN_OPERATION))
                    column.setWidth(0);
                else
                    column.pack();
            }
        }
    }
    
    public boolean isEditableEffort(){
    	return this.isEditableEffort;
    }
    
    protected void finalize() throws Throwable
    {
      this.disposeWidgets();
      this.factory.cleanup();
      super.finalize(); //not necessary if extending Object.
    } 
}
