package de.fzi.kamp.ui.maineditor.stacklayers;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.maineditor.listeners.GoToArchitectureAlternativePageListener;
import de.fzi.kamp.ui.workorganisation.WorkorganisationAdapter;
import de.fzi.kamp.ui.workplanediting.provider.WorkorganisationContentProvider;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;

public class WorkorganisationTreeLayer {

    private final static Logger logger = Logger.getLogger(WorkorganisationTreeLayer.class);

    private TreeViewer workorganisationTreeViewer;

    public void createWorkorganisationTree(final AnalysisManager analysisManager, Display display,
            final SurfaceFactory factory, ScrolledForm form, IMainEditor mainEditor) {

        AdapterFactory adapterFactory = mainEditor.getAdapterFactory();

        FillLayout fillLayout = new FillLayout(SWT.VERTICAL);
        fillLayout.marginHeight = 15;
        fillLayout.marginWidth = 10;
        form.getBody().setLayout(fillLayout);

        Tree tree = new Tree(form.getBody(), SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
        tree.setLayout(new TableWrapLayout());
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.workorganisationTreeViewer = new TreeViewer(tree);

        workorganisationTreeViewer.setContentProvider(new WorkorganisationContentProvider(adapterFactory));
        workorganisationTreeViewer.setLabelProvider(new AdapterFactoryLabelProvider(adapterFactory));
        workorganisationTreeViewer.setInput(mainEditor.getEditingDomain().getResourceSet());

        analysisManager.getAnalysisModel().eAdapters()
                .add(new WorkorganisationAdapter(this.workorganisationTreeViewer));

        workorganisationTreeViewer.setSelection(new StructuredSelection(mainEditor.getEditingDomain().getResourceSet()
                .getResources().get(0)), true);

//        SelectionAdapter[] listener = { new GoToArchitectureAlternativePageListener(mainEditor) };
//        factory.createHorizontalButtonsForEclipseForm(display, form.getBody(),
//                new String[] { "Back To Preparation Page" }, listener, TableWrapData.RIGHT, TableWrapData.RIGHT, false);

    }

    public TreeViewer getWorkorganisationTreeViewer() {
        return workorganisationTreeViewer;
    }

    public Object getWorkorganisationModel(TreeIterator<Notifier> resourceIterator) {
        Object workorganisation = null;
        while (!(workorganisation instanceof WorkOrganisationModel))
            workorganisation = resourceIterator.next();

        return workorganisation;
    }

}
