package de.fzi.kamp.ui.maineditor.stacklayers;

import org.apache.log4j.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.general.ActivityImageProvider;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.maineditor.MainEditorUI;
import de.fzi.kamp.ui.preparation.adapter.ChangeRequestContentAdapter;
import de.fzi.kamp.ui.preparation.listeners.AddChangeRequestListener;
import de.fzi.kamp.ui.preparation.listeners.EditChangeRequestListener;
import de.fzi.kamp.ui.preparation.listeners.RemoveChangeRequestListener;

public class SpecifyChangeScenarioLayer {

    private final static Logger logger = Logger.getLogger(SpecifyChangeScenarioLayer.class);

    private static final String CHANGE_REQUEST_SECTION_HEADING = "Change Request Description:";
    private static final String TABLE_HEADING_NAME = "Name";
    private static final String TABLE_HEADING_DESCRIPTION = "Description";
    private static final String TABLE_HEADING_AUTOMATED = "Automated?";

    private Display display;
    private MainEditorUI mainEditorUI;
    private SurfaceFactory factory = new SurfaceFactory();

    /**
     * Central method to run all necessary methods to build up preparation page.
     * 
     * @param analysisManager
     *            Manager to handle orders concerning the analysis model.
     * @param mainEditor
     *            The editor to display the preparation layer.
     * @param form
     *            The scrolled form containing the preparation layer.
     * @return Returns built up scrolled f
     */
    public void createChangeScenarioLayer(AnalysisManager analysisManager, IMainEditor mainEditor, ScrolledForm form) {

        setupChangeScenarioLayer(mainEditor);

        createChangeRequestPart(analysisManager, display, form);
    }

    /**
     * Assigns all parameters.
     * 
     * @param mainEditor
     *            The editor to display the preparation page.
     */
    public void setupChangeScenarioLayer(IMainEditor mainEditor) {
        mainEditorUI = (MainEditorUI) mainEditor;
        display = mainEditorUI.getEditorSite().getShell().getDisplay();
    }

    /**
     * Creates the section for the change request table and the buttons to modify it.
     * 
     * @param analysisManager
     *            Manager to handle orders concerning the analysis model.
     * @param display
     *            Display showing the editor.
     * @param form
     *            The preparation form.
     */
    private void createChangeRequestPart(AnalysisManager analysisManager, Display display, ScrolledForm form) {
        /*
         * Section 2 for change request table
         */
        Section changeRequestSection = factory.createSection(form.getBody(), CHANGE_REQUEST_SECTION_HEADING,
                Section.TITLE_BAR, TableWrapData.FILL, true, display, 1);

        Composite sectionClient2 = factory.createCompositeForSection(changeRequestSection, 2,
                TableWrapData.CENTER, 1, SWT.NONE, 15, 15, display);
        Table changeReqTable = factory.createTable(sectionClient2, 1, new String[] { TABLE_HEADING_NAME,
                TABLE_HEADING_DESCRIPTION, TABLE_HEADING_AUTOMATED }, SWT.FILL, true);
        factory.setSizeForControl(changeReqTable, 0, 150, false);

        SelectionAdapter[] listenersChangeButtons = { new AddChangeRequestListener(changeReqTable, analysisManager),
                new EditChangeRequestListener(changeReqTable, analysisManager),
                new RemoveChangeRequestListener(changeReqTable, analysisManager) };
        factory.createVerticalButtonComposite(sectionClient2, SWT.RIGHT, SWT.FILL, null, SWT.NONE,
                listenersChangeButtons, null, new Image[] { ActivityImageProvider.getIconForAddButton(),
                        ActivityImageProvider.getIconForEditButton(), ActivityImageProvider.getIconForDeleteButton() });

        // register adapter for change request list (note: in emf "adapter" = "observer"
        analysisManager.getAnalysisModel().eAdapters().add(
                new ChangeRequestContentAdapter(changeReqTable, analysisManager.getAnalysisModel()));

        changeRequestSection.setClient(sectionClient2);
    }
    
    protected void finalize() throws Throwable
    {
      this.factory.cleanup();
      super.finalize(); //not necessary if extending Object.
    } 

}