package de.fzi.kamp.ui.maineditor.stacklayers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.analysisoverview.adapters.AnalysisInstanceContentAdapter;
import de.fzi.kamp.ui.analysisoverview.adapters.AnalysisInstanceItemAdapter;
import de.fzi.kamp.ui.analysisoverview.adapters.SummaryTableContentAdapter;
import de.fzi.kamp.ui.analysisoverview.listeners.AddAnalysisInstanceSelectionListener;
import de.fzi.kamp.ui.analysisoverview.listeners.AnalysisInstanceRemoveArchitectureSelectionListener;
import de.fzi.kamp.ui.analysisoverview.listeners.CalculateButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.DeriveButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.EditEffortEstimationButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.EditWorkplanButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.ExportToResultmodelListener;
import de.fzi.kamp.ui.analysisoverview.listeners.ShowResultSummaryButtonListener;
import de.fzi.kamp.ui.analysisoverview.providers.AnalysisInstanceConstants;
import de.fzi.kamp.ui.analysisoverview.providers.AnalysisInstanceContentProvider;
import de.fzi.kamp.ui.analysisoverview.providers.AnalysisInstanceLabelProvider;
import de.fzi.kamp.ui.analysisoverview.providers.SummaryTableContentProvider;
import de.fzi.kamp.ui.analysisoverview.providers.SummaryTableLabelProvider;
import de.fzi.kamp.ui.general.ActivityImageProvider;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.maineditor.listeners.GoToArchitectureAlternativePageListener;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;

public class AnalysisInstanceLayer {

    private final static Logger logger = Logger.getLogger(AnalysisInstanceLayer.class);
    
    private List<Widget> widgets;
    
    public List<Widget> getWidgets() {
        return widgets;
    }

    private SurfaceFactory factory;
    private Composite comp;
    private Display display;
    private Table table;
    private AnalysisManager analysisManager;
    private IMainEditor mainEditorUI;
    private TableViewer tableViewer;

    public AnalysisInstanceLayer() {
        disposeWidgets();
    }
    
    public void disposeWidgets() {
        if (this.widgets != null && !this.widgets.isEmpty()) {
            for (Widget widget : this.widgets) {
                widget.dispose();
            }
        }
        this.widgets = new ArrayList<Widget>();
    }
    
    public void createAnalysisInstancePage(AnalysisManager analysisManager, Display display, ScrolledForm form,
            IMainEditor mainEditorUI) {

        this.display = display;
        this.mainEditorUI = mainEditorUI;
        this.analysisManager = analysisManager;
        this.factory = new SurfaceFactory();
        
        this.comp = factory.createCompositeForEclipseForm(display, form.getBody(), SWT.NONE, TableWrapData.FILL, true,
                1, 1);

        this.widgets.add(comp);
        
        createAnalysisInstancesTable();
        this.factory.setSizeForControl(this.table, 0, 300, false);
        Section section = createButtonSection();

        this.table.moveBelow(section);
        Section effortSumarytableSection = createSummaryTable();
        
        //createNavigationButton(effortSumarytableSection);
        //createExportInResultModelButton(form);
               
    }

    /**
     * Creates the table that shows all pairs of architecture alternative and chnage request
     * including the buttons to edit all data.
     */
    private void createAnalysisInstancesTable() {

        this.table = this.factory.createTableForAnalysisInstanceLayer(display, comp, SWT.BORDER | SWT.FULL_SELECTION,
                AnalysisInstanceConstants.getMainTableCaptions(), true, TableWrapData.FILL, 1);

        table.addListener(SWT.MeasureItem, new Listener() {
            public void handleEvent(Event event) {
                event.height = 30;
            }
        });
        
        this.widgets.add(table);

        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider(new AnalysisInstanceContentProvider());
        this.tableViewer.setLabelProvider(new AnalysisInstanceLabelProvider());
        this.tableViewer.setInput(this.analysisManager.getAnalysisModel());

        analysisManager.getAnalysisModel().eAdapters().add(
                new AnalysisInstanceContentAdapter(this.table, this.tableViewer, this.analysisManager
                        .getAnalysisInstanceManager(), this.mainEditorUI, this));

        this.table.getColumn(AnalysisInstanceConstants.MAINTABLECOLUMN_INDEX_RESULT_SUMMARY).setAlignment(SWT.CENTER);
        setWorkComplexityColumnInvisible(table);
    }

    /**
     * Creates the table which shows the accumulated effort of all change request for each
     * architecture alternative.
     */
    private Section createSummaryTable() {
        Section section = this.factory.createSection(comp, "Result Summary",
                Section.TITLE_BAR, TableWrapData.LEFT, false, display, 1);
        section.setFont(SurfaceFactory.getFontStyle().get(SurfaceFactory.STYLE_ANSWER));

        this.widgets.add(section);

        section.marginHeight = 10;
        
        Table summaryTable = factory.createTableWithToolkit(display, section, SWT.FULL_SELECTION | SWT.NONE,
                AnalysisInstanceConstants.getSummaryTableCaptions(), false, SWT.LEFT, 1);
        summaryTable.setHeaderVisible(false);
        summaryTable.setLinesVisible(false);

        this.widgets.add(summaryTable);
        
        summaryTable.addListener(SWT.MeasureItem, new Listener() {
            public void handleEvent(Event event) {
                event.height = 25;
            }
        });

        TableViewer viewer = new TableViewer(summaryTable);
        viewer.setContentProvider(new SummaryTableContentProvider());
        viewer.setLabelProvider(new SummaryTableLabelProvider());
        viewer.setInput(this.analysisManager.getAnalysisModel());

        this.factory.setSizeForControl(summaryTable, 0, 100, false);

        SummaryTableContentAdapter contentAdapter = new SummaryTableContentAdapter(summaryTable, viewer);
        this.analysisManager.getAnalysisModel().eAdapters().add(contentAdapter);

        section.setClient(summaryTable);

        return section;
    }

    /**
     * Creates the section that contains the buttons to add and remove analysis instances.
     * 
     * @return
     */
    private Section createButtonSection() {
        Section section = this.factory.createSection(comp, "Analysis Instance", Section.TITLE_BAR,
                TableWrapData.LEFT, false, display, 1);
        section.setFont(SurfaceFactory.getFontStyle().get(SurfaceFactory.STYLE_ANSWER));

        this.widgets.add(section);
        
        SelectionAdapter[] listenerArray = { new AddAnalysisInstanceSelectionListener(table, analysisManager),
                new AnalysisInstanceRemoveArchitectureSelectionListener(analysisManager, table) };

        section.setClient(this.factory.createHorizontalButtonsForEclipseForm(display, section, new String[] { "",
                "" }, listenerArray, TableWrapData.FILL, TableWrapData.CENTER, false, 
                new Image[]{ActivityImageProvider.getIconForAddButton(), ActivityImageProvider.getIconForDeleteButton()}, this.widgets));
        return section;
    }

    /**
     * Creates the button to go back to the preparation page.
     * @param summarySection 
     */
    private void createNavigationButton(Section effortSummaryTableSection) {
    	//ACHTUNG!!!
//        Group group = SurfaceFactory.createGroupWithWhiteBackgroundTableWrap(display, this.comp, "Back to",
//                TableWrapData.LEFT, true, 1, 1);

        Composite comp = this.factory.createHorizontalButtonsForEclipseForm(display, this.comp, new String[] { "Preparation Page" },
                new SelectionAdapter[] { new GoToArchitectureAlternativePageListener(mainEditorUI) }, TableWrapData.CENTER,
                TableWrapData.CENTER, false, new Image[]{ActivityImageProvider.getArrowLeftIcon()}, this.widgets);
        this.widgets.add(comp);
    }

    /**
     * At the moment, the work complexity column is not needed. That's why it is blanked out.
     * 
     * @param table
     */
    private void setWorkComplexityColumnInvisible(Table table) {
        for (TableColumn column : table.getColumns()) {
            if (column.getText() == "Work Complexity") {
                column.setWidth(0);
                column.setResizable(false);
            }
        }
    }

    /**
     * Creates the button that starts the dialog to export the analysis instances to the result
     * model.
     */
    private void createExportInResultModelButton(ScrolledForm form) {
//          Group group = SurfaceFactory.createGroupWithWhiteBackgroundTableWrap(display, comp, "", TableWrapData.RIGHT,
//                true, 2, 1);

        Button button = new org.eclipse.swt.widgets.Button(comp, SWT.NONE);
        button.setImage(ActivityImageProvider.getIconForExportButton());
        button.setText("Export to result model");

        this.widgets.add(button);
        
        TableWrapData tableWrapData = new TableWrapData();
        tableWrapData.align = TableWrapData.LEFT;
        tableWrapData.grabHorizontal = true;
        tableWrapData.colspan = 1;
        button.setLayoutData(tableWrapData);
        
//        GridData data = new GridData();
//        data.grabExcessHorizontalSpace = true;
//        data.horizontalAlignment = GridData.FILL;
//        button.setLayoutData(data);

        button.addSelectionListener(new ExportToResultmodelListener(this.analysisManager, this.mainEditorUI
                .getEditingDomain().getResourceSet(), this.mainEditorUI));
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }
    
    private TableEditor createResultSummaryButton(TableItem item, int column, Table table,
            IAnalysisInstanceManager manager, AnalysisInstanceItemAdapter itemadapter, EffortAnalysisInstance instance,
            IMainEditor mainEditor) {

        Composite comp = factory.createButtonComposite(table);
        Button button = factory.createButton(comp, "Show", new ShowResultSummaryButtonListener(manager, instance, mainEditor));
        button.setEnabled(false);
        itemadapter.setShowResultSummaryButton(button);

        this.widgets.add(comp);
        this.widgets.add(button);
        
        TableEditor editor = new TableEditor(table);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor(comp, item, column);
        editor.layout();
        
        return editor;
    }
    
    public void layout() {
        this.comp.getParent().layout(true, true);
        this.comp.getParent().redraw();
    }
    

    protected void finalize() throws Throwable
    {
      this.disposeWidgets();
      this.factory.cleanup();
      super.finalize(); //not necessary if extending Object.
    } 

}
