package de.fzi.kamp.ui.maineditor;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;

import de.fzi.kamp.service.architecturemodel.ArchitectureModelProviderFactory;
import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.kamp.service.maineditor.ICentralEditorPage;
import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.analysisoverview.adapters.AnalysisInstanceItemAdapter;
import de.fzi.kamp.ui.general.DialogManager;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.general.WizardManager;
import de.fzi.kamp.ui.maineditor.page.CentralEditorPage;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.main.presentation.MainActionBarContributor;
import de.fzi.maintainabilitymodel.main.presentation.MainEditor;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;
import de.fzi.maintainabilitymodel.workorganisation.WorkorganisationFactory;
import de.fzi.maintainabilitymodel.workplan.Workplan;

public class MainEditorUI extends MainEditor implements IMenuListener, IEditingDomainProvider, IMainEditor,
        ICommandHandler {

    private final static Logger logger = Logger.getLogger(MainEditorUI.class);

    private AnalysisManager analysisManager;
    public AnalysisManager getAnalysisManager() {
        return analysisManager;
    }

    private IArchitectureModelProvider architectureModelProvider;
    private CentralEditorPage centralPageFactory;
    private Control centralPage;
    private int centralPageIndex;
    private IProject parentQImpressProject;

    public AdapterFactoryEditingDomain getEditingDomain() {
        return editingDomain;
    }

    public ComposedAdapterFactory getAdapterFactory() {
        return adapterFactory;
    }

    /**
     * This creates a model editor. <!-- begin-user-doc --> <!-- end-user-doc -->
     */
    public MainEditorUI() {
        super();

        BasicConfigurator.configure();
    }

    @Override
    public void createPages() {
        createModel();

        addCentralPage();
        createContextMenu(this.centralPageFactory.getWorkorganisationTreeViewer());
    }

    private void addCentralPage() {

        this.centralPageFactory = new CentralEditorPage();

        this.centralPage = this.centralPageFactory.createAnalysisAndWorkplanForm(this.analysisManager, this
                .getEditorSite().getShell().getDisplay(), getContainer(), this);

        setCurrentViewer(this.centralPageFactory.getWorkorganisationTreeViewer());

        this.centralPageIndex = addPage(this.centralPage);
        setPageText(this.centralPageIndex, "Analysis");
    }

    @Override
    public boolean isDirty() {
        return this.editingDomain.getCommandStack() != null ? ((BasicCommandStack) this.editingDomain.getCommandStack())
                .isSaveNeeded()
                : false;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {

        Resource resource = this.editingDomain.getResourceSet().getResources().get(0);
        try {
            resource.save(null);
        } catch (IOException e) {
            e.printStackTrace();
        }

        ((BasicCommandStack) this.editingDomain.getCommandStack()).saveIsDone();
        firePropertyChange(IEditorPart.PROP_DIRTY);
    }

    @Override
    public void doSaveAs() {
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    /**
     * This creates a context menu for the viewer and adds a listener as well registering the menu
     * for extension. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */

    public void createModel() {
        // TODO Are the load options necessary??? I don't think so...
        URI resourceURI = EditUIUtil.getURI(getEditorInput());
        Resource resource = null;

        resource = editingDomain.getResourceSet().createResource(resourceURI);

        IPath path = new Path(resourceURI.toString());
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile(path);
        // Assumption: A .kamp-file is directly located in the folder of the Q-Impress project, not
        // in subfolders
        this.parentQImpressProject = workspaceRoot.getProject(file.getParent().getName());

        Map loadOptions = ((XMLResourceImpl) resource).getDefaultLoadOptions();
        loadOptions.put(XMLResource.OPTION_DEFER_ATTACHMENT, Boolean.TRUE);
        loadOptions.put(XMLResource.OPTION_DEFER_IDREF_RESOLUTION, Boolean.TRUE);
        loadOptions.put(XMLResource.OPTION_USE_DEPRECATED_METHODS, Boolean.TRUE);
        loadOptions.put(XMLResource.OPTION_USE_PARSER_POOL, new XMLParserPoolImpl());
        loadOptions.put(XMLResource.OPTION_USE_XML_NAME_TO_FEATURE_MAP, new HashMap());

        ((ResourceImpl) resource).setIntrinsicIDToEObjectMap(new HashMap());

        try {
            resource.load(loadOptions);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        if (!editingDomain.getResourceSet().getResources().isEmpty()) {
            Resource res = editingDomain.getResourceSet().getResources().get(0);

            if (res.getContents().size() > 0) {
                if (res.getContents().get(0) instanceof MaintainabilityAnalysisModel) {
                    MaintainabilityAnalysisModel analysisModel = (MaintainabilityAnalysisModel) res.getContents()
                            .get(0);

                    this.architectureModelProvider = ArchitectureModelProviderFactory.createArchitectureModelProvider(
                            this.editingDomain.getResourceSet(), analysisModel, this);

                    if (analysisModel.getWorkorganisation().isEmpty()) {
                        WorkOrganisationModel workOrganisationModel = WorkorganisationFactory.eINSTANCE
                                .createWorkOrganisationModel();
                        analysisModel.getWorkorganisation().add(workOrganisationModel);
                    }

                    analysisManager = new AnalysisManager(analysisModel, this.architectureModelProvider,
                            new DialogManager(this), new WizardManager(), this);
                }
            }
        }
    }

    public void showWorkplanChanges(Workplan workplan, boolean isEditableEffort) {
        centralPageFactory.setWorkplanAsTopControl();
        centralPageFactory.setViewForOpenedWorkplan(workplan, false, isEditableEffort, false);
    }

    protected void createContextMenu(StructuredViewer viewer) {

        super.createContextMenu(viewer);
        if (this.getActionBarContributor() instanceof MainActionBarContributor) {
            this.getActionBarContributor().setActiveEditor(this);
            viewer.addSelectionChangedListener((MainActionBarContributor) this.getActionBarContributor());
        }
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        // Make sure it's okay.
        //
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable() {
                public void run() {
                    // Try to select the items in the current content viewer of the editor.
                    //
                    if (centralPageFactory.getWorkorganisationTreeViewer() != null) {
                        centralPageFactory.getWorkorganisationTreeViewer().setSelection(
                                new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            getSite().getShell().getDisplay().asyncExec(runnable);
        }

    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor) getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return getActionBarContributor().getActionBars();
    }

    public ICentralEditorPage getCentralPage() {
        return this.centralPageFactory;
    }

    @Override
    public IArchitectureModelProvider getArchitectureModelProvider() {
        return this.architectureModelProvider;
    }

    @Override
    public void handleCommand(Command command) {
        logger.debug(command.toString());
        this.getCommandStack().execute(command);
    }

    @Override
    public Shell getMainEditorShell() {
        return this.getEditorSite().getShell();
    }

    @Override
    public IProject getParentprojectOfKampFile() {
        return this.parentQImpressProject;
    }

    @Override
    public void notifyAnalysisInstanceAdapter(EffortAnalysisInstance instance) {
        for (Adapter adapter : instance.eAdapters()) {
            if (adapter instanceof AnalysisInstanceItemAdapter) {
                ((AnalysisInstanceItemAdapter) adapter).manualUpdateAfterautomaticDerivation();
            }
        }
    }
    
    protected void finalize() throws Throwable
    {
      super.finalize(); //not necessary if extending Object.
    } 
}
