package de.fzi.kamp.ui.general;

import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.general.IWizardManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.maineditor.MainEditorUI;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.CalculateFollowUpWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.FurtherDerivationWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.DeriveWorkPlanWizard;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;

public class WizardManager implements IWizardManager {
    private final static Logger logger = Logger.getLogger(WizardManager.class);

    @Override
    public List<? extends ComponentSelectionContainer> showAddCompositeActivityWizard(EffortAnalysisInstance instance,
            Shell shell, IMainEditor editor, IArchitectureModelProvider architectureModelProvider) {

        DeriveWorkPlanWizard wizard = new DeriveWorkPlanWizard(instance, editor, architectureModelProvider);
        WizardDialog wizardDialog = new WizardDialog(shell, wizard);
        
        //the -1 has no effect
        wizardDialog.setPageSize(-1, 500);
        wizardDialog.create();
        wizardDialog.open();
        

        return wizard.getSelectedComponents();
    }

    @Override
    public void showFurtherWorkplanDerivationWizard(Tree tree, IMainEditor editor) {
        logger.trace("showFurtherWorkplanDerivationWizard");
        
        FurtherDerivationWizard wizard = new FurtherDerivationWizard(tree, editor);
        WizardDialog wizardDialog = new WizardDialog(((MainEditorUI) editor).getSite().getShell(), wizard);

        wizardDialog.create();
        wizardDialog.open();
    }

    /**
     * Actually starts the wizard where the user can perform the follow up calculation, but also
     * checks some criterions whether the right element in the tree has been chosen.
     */
    @Override
    public void showCalculateFollowUpsWizard(Tree workplanTree, IMainEditor editor) {

        // Is any element in the tree chosen?
        if (workplanTree.getSelectionCount() == 1) {
            TreeItem[] items = workplanTree.getSelection();

            // Is the chosen element an instance of a "Composite Task"?
            if (items[0].getData() instanceof CompositeTask) {

                // Is this composite task perhaps the overall workplan composite task?
                // -> Just composite tasks for concrete change scenarios can be taken for follow up
                // calculation.
                if (!(((CompositeTask) items[0].getData()).getSubtasks().get(0) instanceof CompositeTask)) {
                    CalculateFollowUpWizard followUpWizard = new CalculateFollowUpWizard(workplanTree);
                    WizardDialog wizardDialog = new WizardDialog(((MainEditorUI) editor).getSite().getShell(),
                            followUpWizard);

                    wizardDialog.create();
                    wizardDialog.open();
                } else {
                    showErrorMessage(
                            "Please choose a composite activity for a concrete changing scenario\n"
                                    + "and not the one for the whole workplan.", editor.getMainEditorShell());
                }
            } else {
                showErrorMessage("You have to choose an *composite activity*\n"
                        + "to start follow up calculation.", editor.getMainEditorShell());
            }
        } else {
            showErrorMessage("You have to choose an activity in the tree\n "
                    + "to start the follow up calculation.", editor.getMainEditorShell());
        }
    }

    /**
     * Opens a message box to display a mistake, if the user has chosen a wrong item in the tree to
     * perform the follow up calculation on it.
     * 
     * @param message
     * @param shell
     */
    public void showErrorMessage(String message, Shell shell) {
        MessageBox messageBox = new MessageBox(shell, SWT.ICON_ERROR);

        messageBox.setText("Error");
        messageBox.setMessage(message);

        messageBox.open();
    }
}
