package de.fzi.kamp.ui.general;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.analysisoverview.adapters.AnalysisInstanceContentAdapter;
import de.fzi.kamp.ui.analysisoverview.adapters.AnalysisInstanceItemAdapter;
import de.fzi.kamp.ui.analysisoverview.listeners.CalculateButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.DeriveButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.EditEffortEstimationButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.EditWorkplanButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.ShowResultSummaryButtonListener;
import de.fzi.kamp.ui.analysisoverview.providers.AnalysisInstanceConstants;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;

public class SurfaceFactory {
    private final static Logger logger = Logger.getLogger(SurfaceFactory.class);

    public static final String STYLE_HEADING = "headingStyle";
    public static final String STYLE_HEADING_EDITORPAGE = "editorpageheadingStyle";
    public static final String STYLE_TABLE_HEADING = "tableheadingStyle";
    public static final String STYLE_GROUP = "groupStyle";
    public static final String STYLE_QUESTION = "questionStyle";
    public static final String STYLE_TEXT = "textStyle";
    public static final String STYLE_ANSWER = "answerStyle";
    public static final String STYLE_FOOTNOTE_HEADING = "footnoteHeadingStyle";
    public static final String STYLE_FOOTNOTE_TEXT = "footnoteTextStyle";
 
    public static FontRegistry fontRegistry;
    
    public List<Widget> widgets = new ArrayList<Widget>();
    
    public void cleanup() {
        //List<Widget> usedWidgets = new ArrayList<Widget>();
        for (Widget widget : widgets) {
            if (!widget.isDisposed()) {
                //usedWidgets.add(widget); 
                widget.dispose();
            } else {
                
            }
        }
    }
    
    public static FontRegistry getFontStyle() {

        if (fontRegistry==null) {
            fontRegistry = new FontRegistry();
    
            fontRegistry.put(STYLE_HEADING, new FontData[] { new FontData("Helvetica", 11, SWT.BOLD) });
            fontRegistry.put(SurfaceFactory.STYLE_HEADING_EDITORPAGE,
                    new FontData[] { new FontData("Helvetica", 16, SWT.NORMAL) });
            fontRegistry.put(SurfaceFactory.STYLE_TABLE_HEADING, new FontData[] { new FontData("Helvetica", 10, SWT.BOLD) });
            fontRegistry.put(SurfaceFactory.STYLE_GROUP, new FontData[] { new FontData("Helvetica", 10, SWT.NORMAL) });
            fontRegistry.put(SurfaceFactory.STYLE_QUESTION, new FontData[] { new FontData("Helvetica", 10, SWT.BOLD) });
            fontRegistry.put(SurfaceFactory.STYLE_TEXT, new FontData[] { new FontData("Helvetica", 9, SWT.NORMAL) });
            fontRegistry.put(SurfaceFactory.STYLE_ANSWER, new FontData[] { new FontData("Helvetica", 9, SWT.NORMAL) });
    
            fontRegistry.put(SurfaceFactory.STYLE_FOOTNOTE_HEADING, new FontData[] { new FontData("bla", 7, SWT.BOLD) });
            fontRegistry.put(SurfaceFactory.STYLE_FOOTNOTE_TEXT, new FontData[] { new FontData("bla", 7, SWT.NORMAL) });
        }

        return fontRegistry;
    }

    private static Map<String, Color> colorCache = new HashMap<String, Color>();

    public Color lookupColor(Display display, int red, int green, int blue, String key) {
        
        if (colorCache.containsKey(key)) {
            Color color = colorCache.get(key);
            if (color != null) {
                return color;
            }
        }
        
        Color color = new Color(display, red, green, blue);
        colorCache.put(key, color);
        return color;
    }
    
    public Section createSection(Composite form, String title, int sectionStyle, int horizontalAlignTableWrap,
            Boolean grabHorizontal, Display display, int colspan) {
        
        Section section = new Section(form, sectionStyle);
        section.setText(title);
        //section.setTitleBarBackground(new Color(display, 204, 236, 241));
        section.setTitleBarBackground(lookupColor(display, 210, 230, 255, "titlebar"));
        section.setBackground(lookupColor(display, 255, 255, 255, "background"));
        section.setForeground(lookupColor(display, 0, 0, 0, "foreground"));
        //section.setTitleBarBorderColor(lookupColor(display, 0, 119, 75, ""));
        section.setTitleBarBorderColor(lookupColor(display, 0, 0, 200, "titlebarborder"));
        section.setFont(SurfaceFactory.getFontStyle().get(SurfaceFactory.STYLE_GROUP));

        TableWrapData td = new TableWrapData();
        td.align = horizontalAlignTableWrap;
        td.grabHorizontal = grabHorizontal;
        td.colspan = colspan;
        section.setLayoutData(td);

        widgets.add(section);
        
        return section;
    }

    public Composite createVerticalButtonComposite(Composite parent, int horizontalAlignmentComposite,
            int horizontalAlignmentButton, String[] buttonText, int buttonSyle) {
        return createVerticalButtonComposite(parent, horizontalAlignmentComposite, horizontalAlignmentButton,
                buttonText, buttonSyle, null, null, null);
    }

    public Composite createVerticalButtonComposite(Composite parent, int horizontalAlignmentComposite,
            int horizontalAlignmentButton, String[] buttonText, int buttonSyle, SelectionAdapter[] listener) {
        return createVerticalButtonComposite(parent, horizontalAlignmentComposite, horizontalAlignmentButton,
                buttonText, buttonSyle, listener, null, null);
    }

    public Composite createVerticalButtonComposite(Composite parent, int horizontalAlignmentComposite,
            int horizontalAlignmentButton, String[] buttonText, int buttonSyle, SelectionAdapter[] listener, String[] toolTips) {
        return createVerticalButtonComposite(parent, horizontalAlignmentComposite, horizontalAlignmentButton,
                buttonText, buttonSyle, listener, toolTips, null);
    }

    public Composite createVerticalButtonComposite(Composite parent, int horizontalAlignmentComposite,
            int horizontalAlignmentButton, String[] buttonText, int buttonSyle, SelectionAdapter[] listener,
            String[] toolTips, Image[] images) {

        Composite compForButtons = new Composite(parent, SWT.NONE);
        compForButtons.setLayout(new GridLayout());
        GridData gdCompForButtons = new GridData();
        gdCompForButtons.horizontalAlignment = SWT.LEFT;
        gdCompForButtons.grabExcessHorizontalSpace = true;
        compForButtons.setLayoutData(gdCompForButtons);

        int numberOfButtons = 0;
        if (buttonText != null) {
            numberOfButtons = buttonText.length;
        } else if (images != null) {
            numberOfButtons = images.length;
        }
            
        for (int i = 0; i < numberOfButtons; i++) {

            Button button = new Button(compForButtons, buttonSyle);
            if ((buttonText != null) && (i < buttonText.length)) {
                button.setText(buttonText[i]);
            }
            GridData gdLoadButton = new GridData();
            gdLoadButton.horizontalAlignment = horizontalAlignmentButton;
            gdLoadButton.grabExcessHorizontalSpace = true;
            button.setLayoutData(gdLoadButton);
            button.setFont(SurfaceFactory.getFontStyle().get(SurfaceFactory.STYLE_ANSWER));
            if ((listener != null) && (i < listener.length)) {
                button.addSelectionListener(listener[i]);
            }
            if ((toolTips != null) && (i < toolTips.length)) {
                button.setToolTipText(toolTips[i]);
            }
            if ((images != null) && (i < images.length)) {
                if (images[i] != null)
                    button.setImage(images[i]);
            }

        }

        widgets.add(compForButtons);

        return compForButtons;
    }

    public Composite createHorizontalButtonCompositeWithToolkit(Composite parent, Boolean withLeadingLabel,
            String labelText, String[] buttonText, int horizontalAlignmentComp, int horizontalAlignmentButton,
            Display display, Boolean withToolkit, SelectionAdapter[] selectionListener) {

        FormToolkit toolkit = new FormToolkit(display);
        Composite comp;

        if (withToolkit)
            comp = toolkit.createComposite(parent);
        else
            comp = new Composite(parent, SWT.NONE);

        GridLayout gl = new GridLayout();
        GridData gdButton = new GridData();
        GridData gdComp = new GridData();
        gdComp.horizontalAlignment = horizontalAlignmentComp;

        if (withLeadingLabel) {
            gl.numColumns = buttonText.length + 1;
        } else {
            gl.numColumns = buttonText.length;
        }

        comp.setLayout(gl);
        comp.setLayoutData(gdComp);

        if (withLeadingLabel) {
            Label label = new Label(comp, SWT.NONE);
            widgets.add(label);
            label.setText(labelText);
            label.setFont(SurfaceFactory.getFontStyle().getBold(SurfaceFactory.STYLE_ANSWER));
        }

        for (int i = 0; i < buttonText.length; i++) {
            Button button = new Button(comp, SWT.NONE);
            button.setText(buttonText[i]);
            button.setFont(SurfaceFactory.getFontStyle().get(SurfaceFactory.STYLE_ANSWER));
            gdButton.horizontalAlignment = horizontalAlignmentButton;
            button.setLayoutData(gdButton);

            widgets.add(button);

            button.addSelectionListener(selectionListener[i]);
        }

        widgets.add(comp);

        return comp;
    }

    public Table createTable(Composite parent, int horizontalSpan, String[] columns, int horizontalAlignment,
            boolean grabHorizontal) {

        final Table table = new Table(parent, SWT.SINGLE | SWT.BORDER | SWT.FULL_SELECTION);
        table.setLayout(new GridLayout());
        /* Set GridData for the table */
        GridData gdTable = new GridData();
        gdTable.horizontalAlignment = horizontalAlignment;
        gdTable.horizontalSpan = horizontalSpan;
        gdTable.grabExcessHorizontalSpace = grabHorizontal;
        table.setLayoutData(gdTable);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setFont(SurfaceFactory.getFontStyle().get(SurfaceFactory.STYLE_TABLE_HEADING));

        for (int i = 0; i < columns.length; i++) {
            TableColumn column = new TableColumn(table, SWT.NONE);
            column.setText(columns[i]);
        }

        for (int j = 0; j < table.getColumnCount(); j++) {
            table.getColumn(j).pack();
        }
        widgets.add(table);

        return table;
    }

    public Tree createTree(Composite parent, int horizontalAlignment, int horizontalSpan,
            boolean grabHorizontal, int style, String[] columns) {

        Tree tree = new Tree(parent, style | SWT.H_SCROLL | SWT.V_SCROLL);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);

        GridData treeData = new GridData();
        treeData.horizontalAlignment = horizontalAlignment;
        treeData.horizontalSpan = horizontalSpan;
        treeData.grabExcessHorizontalSpace = grabHorizontal;
        tree.setLayoutData(treeData);

        for (String columnText : columns) {
            TreeColumn column = new TreeColumn(tree, SWT.CENTER);
            column.setText(columnText);
            column.pack();
            widgets.add(column);
        }

        widgets.add(tree);

        return tree;
    }

    public void fillTable(Table table) {

        for (int i = 0; i < 100; i++) {

            TableItem item = new TableItem(table, SWT.NONE);
            item.setFont(SurfaceFactory.getFontStyle().get(SurfaceFactory.STYLE_TEXT));

            for (int j = 0; j < table.getColumnCount(); j++) {

                if (table.getColumn(j).getText() == "ID") {
                    item.setText(j, i + "");
                } else {
                    item.setText(j, "Item " + i);
                }
            }
            
            widgets.add(item);
        }
    }

    public Composite createCompositeOrGroup(final Composite container, int numClumns, int horizontalAlignment,
            int horizontalSpan, int compositeStyle, boolean group) {

        return createCompositeOrGroup(container, numClumns, horizontalAlignment, horizontalSpan, compositeStyle, group,
                5, 5);
    }

    public Composite createCompositeOrGroup(final Composite container, int numClumns, int horizontalAlignment,
            int horizontalSpan, int compositeStyle, boolean group, int marginWidth, int marginHeight) {

        Composite comp;

        GridLayout glUp = new GridLayout();
        glUp.numColumns = numClumns;
        glUp.marginWidth = marginWidth;
        glUp.marginHeight = marginHeight;

        GridData gdUp = new GridData();
        gdUp.horizontalAlignment = horizontalAlignment;
        gdUp.horizontalSpan = horizontalSpan;

        if (!group) {
            comp = new Composite(container, compositeStyle);
            comp.setLayout(glUp);
            comp.setLayoutData(gdUp);
        } else {
            comp = new Group(container, compositeStyle);
            comp.setLayout(glUp);
            comp.setLayoutData(gdUp);
        }

        widgets.add(comp);

        return comp;
    }

    public void createHeading(Composite upperPart, String title, int horizontalSpan, int horizontalAlignment,
            boolean group) {

        if (group) {
            Group labelGroup = new Group(upperPart, SWT.NONE);
            labelGroup.setLayout(new GridLayout());
            GridData gdGroup = new GridData();
            gdGroup.grabExcessHorizontalSpace = true;
            gdGroup.horizontalAlignment = horizontalAlignment;
            gdGroup.horizontalSpan = horizontalSpan;
            labelGroup.setLayoutData(gdGroup);
            widgets.add(labelGroup);

            Label AALabel = new Label(labelGroup, SWT.NONE);
            AALabel.setText(title);
            AALabel.setFont(SurfaceFactory.getFontStyle().getBold(STYLE_TEXT));
            widgets.add(AALabel);
        }

        else {
            Label AALabel = new Label(upperPart, SWT.NONE);
            AALabel.setText(title);
            widgets.add(AALabel);

            GridData gdLabel = new GridData();
            gdLabel.grabExcessHorizontalSpace = true;
            gdLabel.horizontalAlignment = horizontalAlignment;
            gdLabel.horizontalSpan = horizontalSpan;

            AALabel.setLayoutData(gdLabel);
            AALabel.setFont(SurfaceFactory.getFontStyle().getBold(SurfaceFactory.STYLE_TEXT));
        }

    }

    public Composite createCompositeForSection(final Composite container, int numClumns,
            int horizontalAlignment, int horizontalSpan, int compositeStyle, int marginWidth, int marginHeight,
            Display display) {

        FormToolkit toolkit = new FormToolkit(display);

        Composite comp = toolkit.createComposite(container, compositeStyle);
        widgets.add(comp);

        GridLayout gl = new GridLayout();
        gl.numColumns = numClumns;
        gl.verticalSpacing = 25;
        gl.marginWidth = marginWidth;
        gl.marginHeight = marginHeight;

        GridData gd = new GridData(); // GridData for the upper part
        gd.horizontalAlignment = horizontalAlignment;
        gd.horizontalSpan = horizontalSpan;

        comp.setLayout(gl);
        comp.setLayoutData(gd);

        return comp;

    }

    public Composite createHorizontalButtonsForEclipseForm(Display display, Composite parent,
            String[] buttonTexts, SelectionAdapter[] listeners, int horizontalAlignmentComp,
            int horizontalAlignmentButton, boolean makeColumnsEqualWidth, List<Widget> widgets) {
    	 
    	return createHorizontalButtonsForEclipseForm(display, parent, buttonTexts, listeners, 
    			horizontalAlignmentComp, horizontalAlignmentButton, makeColumnsEqualWidth, null, widgets);
    }

    
    public Composite createHorizontalButtonsForEclipseForm(Display display, Composite parent,
            String[] buttonTexts, SelectionAdapter[] listeners, int horizontalAlignmentComp,
            int horizontalAlignmentButton, boolean makeColumnsEqualWidth, Image[] buttonImages, List<Widget> widgets) {

        FormToolkit toolkit = new FormToolkit(display);

        Composite compositeForButtons = toolkit.createComposite(parent, SWT.NONE);
        TableWrapLayout twLayout = new TableWrapLayout();
        twLayout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        twLayout.numColumns = buttonTexts.length;
        twLayout.bottomMargin = 1;
        twLayout.topMargin = 1;
        twLayout.leftMargin = 1;
        twLayout.rightMargin = 1;
        compositeForButtons.setLayout(twLayout);

        widgets.add(compositeForButtons);
        
        TableWrapData td = new TableWrapData();
        td.align = horizontalAlignmentComp;
        td.grabHorizontal = true;

        compositeForButtons.setData(td);

        for (int i = 0; i < buttonTexts.length; i++) {
            TableWrapData gd = new TableWrapData();
            gd.grabHorizontal = true;
            gd.align = horizontalAlignmentButton;
            Button button = toolkit.createButton(compositeForButtons, buttonTexts[i], SWT.NONE);
            if (buttonImages != null && i < buttonImages.length){
            	button.setImage(buttonImages[i]);
            }
            button.setLayoutData(gd);
            button.addSelectionListener(listeners[i]);
            widgets.add(button);
        }

        return compositeForButtons;
    }

    public Label createIndentedLabel(Composite parent, String labelText, int indent, int style, List<Widget> widgetList) {

        Label label = new Label(parent, style);
        label.setText(labelText);

        GridData gd = new GridData();
        gd.widthHint = indent;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = SWT.FILL;
        label.setLayoutData(gd);

        widgetList.add(label);
        
        widgets.add(label);

        return label;

    }

    public Button createFirstLevelOptionRadio(Composite parent, String optionText, int horizontalSpan, List<Widget> widgetList) {

        Button button = new Button(parent, SWT.RADIO);
        button.setText(optionText);

        GridLayout gdB = new GridLayout();
        gdB.numColumns = 2;
        // button.setLayoutData(gdB); //there's a mistake

        widgetList.add(button);
        /*
         * Label answer = new Label(option, SWT.NONE); answer.setFont(new
         * WizardFactory().getFontStyle().get(SurfaceFactory.STYLE_ANSWER));
         * answer.setText(optionText);
         */
        widgets.add(button);

        return button;

    }

    public Group createGroupWithWhiteBackgroundTableWrap(Display display, Composite comp, String text,
            int horizontalAlignment, Boolean grabExcessHorizontalSpace, int horizontalSpan, int numColumns) {

        Group group = new Group(comp, SWT.NONE);
        group.setText(text);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = numColumns;

//        GridLayout layout = new GridLayout();
//        layout.numColumns = numColumns;
        group.setLayout(layout);

        TableWrapData wrapData = new TableWrapData();
        wrapData.grabHorizontal = grabExcessHorizontalSpace;
        wrapData.align = horizontalAlignment;
        wrapData.colspan = horizontalSpan;
        group.setLayoutData(wrapData);

        group.setBackground(lookupColor(display, 255, 255, 255, "background"));

        widgets.add(group);
        
        return group;
    }

    public Composite createCompositeForEclipseForm(Display display, Composite parent, int compStyle, int alignWrap,
            Boolean grabHorizontal, int colspan, int numColumns) {

        FormToolkit toolkit = new FormToolkit(display);

        Composite comp = toolkit.createComposite(parent, compStyle);
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = numColumns;

        TableWrapData twd = new TableWrapData();
        twd.align = alignWrap;
        twd.grabHorizontal = grabHorizontal;
        twd.colspan = colspan;

        comp.setLayout(twl);
        comp.setLayoutData(twd);

        widgets.add(comp);
        
        return comp;

    }

    public Table createTableWithToolkit(Display display, Composite parent, int tableStyle, String[] headers,
            Boolean grabHorizontal, int horizontalAlignment, int colspan) {

        FormToolkit toolkit = new FormToolkit(display);
        Table table = toolkit.createTable(parent, tableStyle);

        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        TableWrapData twd = new TableWrapData();
        twd.align = horizontalAlignment;
        twd.grabHorizontal = grabHorizontal;
        twd.colspan = colspan;
        twd.heightHint = 100;

        table.setLayoutData(twd);
        
        widgets.add(table);

        for (int i = 0; i < headers.length; i++) {
            TableColumn tc = new TableColumn(table, SWT.NONE);
            tc.setText(headers[i]);
            tc.pack();
            widgets.add(tc);

        }

        return table;
    }

    public Table createTableForAnalysisInstanceLayer(Display display, Composite parent, int tableStyle,
            String[] headers, Boolean grabHorizontal, int horizontalAlignment, int colspan) {

        FormToolkit toolkit = new FormToolkit(display);
        Table table = toolkit.createTable(parent, tableStyle);

        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        TableWrapData twd = new TableWrapData();
        twd.align = horizontalAlignment;
        twd.grabHorizontal = grabHorizontal;
        twd.colspan = colspan;

        table.setLayoutData(twd);

        table.setFont(getFontStyle().get(STYLE_QUESTION));

        widgets.add(table);

        
        for (int i = 0; i < headers.length; i++) {
            TableColumn tc = new TableColumn(table, SWT.NONE);
            tc.setText(headers[i]);
            tc.pack();
            widgets.add(tc);

        }
       

        return table;
    }

    public Tree createTreeforEclipseForm(Display display, Composite parent, String[] columns, int align,
            Boolean grabHorizontal, int colspan, int heightHint) {
        FormToolkit toolkit = new FormToolkit(display);
        Tree tree = toolkit.createTree(parent, SWT.BORDER | SWT.FULL_SELECTION);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        widgets.add(tree);

        
        TableWrapData data = new TableWrapData();
        data.align = align;
        data.grabHorizontal = grabHorizontal;
        data.colspan = colspan;
        data.heightHint = heightHint;

        for (int i = 0; i < columns.length; i++) {
            TreeColumn column = new TreeColumn(tree, SWT.NONE);
            column.setText(columns[i]);
            column.pack();
            widgets.add(column);
        }

        tree.setLayoutData(data);
        tree.setFont(SurfaceFactory.getFontStyle().get(STYLE_TABLE_HEADING));

        return tree;
    }

    public void removeArchitectureAlternativeFromOverviewTable(Table table, int index) {
        try {
            TableEditor editor = new TableEditor(table);
            editor.getEditor().dispose();
            table.remove(index);
            table.update();
        } catch (Exception e) {

        }
    }

    public Composite createButtonComposite(Composite parent) {

        Composite comp = new Composite(parent, SWT.NONE);
        widgets.add(comp);

        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        comp.setLayout(layout);

        GridData data = new GridData();
        data.horizontalAlignment = SWT.FILL;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        comp.setLayoutData(data);

        comp.setBackground(lookupColor(comp.getDisplay(), 255, 255, 255, "background"));

        return comp;
    }

    public Button createButton(Composite parent, Image image, SelectionAdapter listener) {
    	Button button = createButton(parent, "", listener);
    	button.setImage(image);
    	return button;
    }

    public Button createButton(Composite parent, String text, SelectionAdapter listener) {

        Button button = new Button(parent, SWT.NONE);
        widgets.add(button);
        if(!text.equals("")){
        	button.setText(text);
        }
        button.addSelectionListener(listener);

        GridData data = new GridData();
        data.horizontalAlignment = SWT.FILL;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        button.setLayoutData(data);

        return button;
    }

    public void setControlWithTableEditor(Table table, TableItem item, Control control, int column) {

        TableEditor editor = new TableEditor(table);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor(control, item, column);
    }

    public void setControlWithTableTreeEditor(Tree tree, TreeItem item, Control control, int column) {
        TreeEditor editor = new TreeEditor(tree);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor(control, item, column);
    }

    public Combo createCombo(TableItem itemForAssociatedInterface, String[] itemsToAdd, Table table, int column) {

        Combo combo = new Combo(table, SWT.READ_ONLY);
        widgets.add(combo);
        
        for (String text : itemsToAdd) {
            combo.add(text);
        }

        setControlWithTableEditor(table, itemForAssociatedInterface, combo, column);
        return combo;
    }

    public void configureCompositeForTableWrapLayout(Composite composite, int numColumns, int align, int colspan,
            boolean grabHorizintal, Color background) {
        configureCompositeForTableWrapLayout(composite, numColumns, align, colspan, grabHorizintal, background, -1);
    }

    public void configureCompositeForTableWrapLayout(Composite composite, int numColumns, int align, int colspan,
            boolean grabHorizintal, Color background, int maxWidth) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = numColumns;
        layout.bottomMargin = 1;
        layout.topMargin = 1;
        layout.leftMargin = 1;
        layout.rightMargin = 2;
        // layout.horizontalSpacing = 1;
        // layout.verticalSpacing = 1;

        TableWrapData data = new TableWrapData();
        data.align = align;
        data.colspan = colspan;
        data.grabHorizontal = grabHorizintal;
        if (maxWidth != -1)
            data.maxWidth = maxWidth;

        composite.setBackground(background);

        composite.setLayout(layout);
        composite.setLayoutData(data);
    }
    
    public void createButtonsForGivenTableWrapComposite(Composite parent, String[] buttonText, int alignmentButton,
            int buttonStyle, boolean grabHorizontal, SelectionAdapter[] listeners) {
    	
    	createButtonsForGivenTableWrapComposite(parent, buttonText, alignmentButton,
                buttonStyle, grabHorizontal, listeners, null);
    }

    public void createButtonsForGivenTableWrapComposite(Composite parent, String[] buttonText, int alignmentButton,
            int buttonStyle, boolean grabHorizontal, SelectionAdapter[] listeners, Image[] buttonImages) {
        int i = 0;
        for (String text : buttonText) {

            Button button = new Button(parent, buttonStyle);
            button.setText(text);
            widgets.add(button);

            if (listeners[i] != null) {
                button.addSelectionListener(listeners[i]);
            }
            
            if (buttonImages != null && i < buttonImages.length){
            	button.setImage(buttonImages[i]);
            }
            
            TableWrapData td = new TableWrapData();
            td.align = alignmentButton;
            td.grabHorizontal = grabHorizontal;

            button.setLayoutData(td);
            i++;
        }
    }

    public Button createChangeSelectionButton(Composite parent, String text, int TODO, int style) {
        Button button = new Button(parent, style);
        widgets.add(button);
        return button;
    }

    public void setSizeForControl(Composite composite, int widthHint, int heighHint, boolean useWidthHint) {
        if (composite.getLayoutData() instanceof GridData) {
            GridData gd = (GridData) composite.getLayoutData();
            gd.heightHint = heighHint;
            if (useWidthHint) {
                gd.widthHint = widthHint;
            }

        } else {
            if (composite.getLayoutData() instanceof TableWrapData) {
                TableWrapData twd = (TableWrapData) composite.getLayoutData();
                twd.heightHint = heighHint;
            }
        }
    }

    public void setGrabVerticalForGridData(Control control, boolean grabVertical, int verticalAlignment) {
        setGrabVerticalForGridData(control, grabVertical, verticalAlignment, false);
    }

    public void setGrabVerticalForGridData(Control control, boolean grabVertical, int verticalAlignment,
            boolean setGridData) {
        if (control.getLayoutData() instanceof GridData) {
            GridData gd = (GridData) control.getLayoutData();
            gd.grabExcessVerticalSpace = grabVertical;
            gd.verticalAlignment = verticalAlignment;
        } else {
            if (setGridData) {
                GridData gd = new GridData();
                gd.grabExcessVerticalSpace = grabVertical;
                gd.verticalAlignment = verticalAlignment;
                control.setLayoutData(gd);
            }
        }
    }

    public void setGrabVerticalForTableWrapData(Control control, boolean grabVertical, int vAlign) {
        if (control.getLayoutData() == null) {
            control.setLayoutData(new TableWrapData());
        }

        if (control.getLayoutData() instanceof TableWrapData) {
            TableWrapData twd = (TableWrapData) control.getLayoutData();
            twd.grabVertical = grabVertical;
            twd.valign = vAlign;
        }
    }

    public void setControlHeight(Control control, int heighHint) {
        if (control.getLayoutData() instanceof GridData)
            ((GridData) control.getLayoutData()).heightHint = heighHint;
        if (control.getLayoutData() instanceof TableWrapData)
            ((TableWrapData) control.getLayoutData()).heightHint = heighHint;
    }

    public void setGridLayout(Control control, int horizontalAlignment, boolean grabHorizontal, int horizontalSpan) {
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = horizontalAlignment;
        layoutData.grabExcessHorizontalSpace = grabHorizontal;
        layoutData.horizontalSpan = horizontalSpan;

        control.setLayoutData(layoutData);
    }

    public void setTableWrapData(Control control, int align, boolean grabHorizontal, int valign, boolean grabVertical,
            int colspan) {

        TableWrapData data = new TableWrapData();
        data.align = align;
        data.grabHorizontal = grabHorizontal;
        data.valign = valign;
        data.grabVertical = grabVertical;
        data.colspan = colspan;

        control.setLayoutData(data);
    }

    public void setControlWidth(Control control, int widthHint) {
        if (control.getLayoutData() instanceof GridData)
            ((GridData) control.getLayoutData()).widthHint = widthHint;
        if (control.getLayoutData() instanceof TableWrapData)
            ((TableWrapData) control.getLayoutData()).maxWidth = widthHint;
    }

    public Button createButton(Composite parent, String text, int style, Image image, SelectionAdapter selectionAdapter) {
        Button button = createButton(parent, text, style);
        
        if (image != null)
            button.setImage(image);
        if (selectionAdapter != null)
            button.addSelectionListener(selectionAdapter);
            
        return button;
    }
    
    public Button createButton(Composite parent, String text, int style) {
        Button button = new Button(parent, style);
        widgets.add(button);
        if (text != null)
            button.setText(text);
        return button;
    }

    public void packTableColums(Table table) {
        for (TableColumn column : table.getColumns()) {
            column.pack();
        }
    }
}
