package de.fzi.kamp.ui.general;

import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import de.fzi.kamp.service.analysisinstance.AlternativeAndChangeRequestTuple;
import de.fzi.kamp.service.commands.EditArchiAltCommand;
import de.fzi.kamp.service.commands.LoadArchiAltCommand;
import de.fzi.kamp.service.general.IDialogManager;
import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.preparation.IPreparationManager;
import de.fzi.kamp.service.preparation.impl.PreparationManager;
import de.fzi.kamp.ui.analysisoverview.dialog.AddAnalysisInstanceAndhangeRequestDialog;
import de.fzi.kamp.ui.preparation.dialogs.AddChangeRequestDialog;
import de.fzi.kamp.ui.preparation.dialogs.ArchitectureAlternativeLoadDialog;
import de.fzi.kamp.ui.workorganisation.MapElementsToDevelopersDialog;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;

public class DialogManager implements IDialogManager {
    private final static Logger logger = Logger.getLogger(DialogManager.class);

    private IMainEditor mainEditor;

    public DialogManager(IMainEditor commandHandler) {
        this.mainEditor = commandHandler;
    }

    @Override
    public void showCheckComplexityAnnotationsWizard() {
        // TODO Auto-generated method stub
    }

    @Override
    public void showEditArchitectureAlternativeDialog(ArchitecturalAlternative architectureAlternative,
            IPreparationManager preparationManager) {

        ArchitectureAlternativeLoadDialog dialog = new ArchitectureAlternativeLoadDialog((Shell) null, null, null,
                true, architectureAlternative);
        dialog.create();
        if (dialog.open() == Dialog.OK) {
            EditArchiAltCommand command = new EditArchiAltCommand(preparationManager, architectureAlternative);
            this.mainEditor.handleCommand(command);
        }
    }

    @Override
    public boolean showEditChangeRequestDialog(ChangeRequest changeRequest) {

        AddChangeRequestDialog dialog = new AddChangeRequestDialog((Shell) null, changeRequest, true);

        dialog.create();
        if (dialog.open() == Dialog.OK) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public boolean showNewChangeRequestDialog(ChangeRequest changeRequest) {

        AddChangeRequestDialog dialog = new AddChangeRequestDialog((Shell) null, changeRequest, false);

        dialog.create();
        dialog.open();

        if (dialog.getReturnCode() == Dialog.OK) {
            return true;
        } else {
            return false;
        }
    }

    public List<AbstractArchitectureModel> showSelectArchitectureModelDialog(
            MaintainabilityAnalysisModel analysisModel, List<AbstractArchitectureModel> architectureModelList,
            List<AbstractArchitectureModel> selectedModels, ArchitecturalAlternative alternative,
            PreparationManager preparationManager) {

        ArchitectureAlternativeLoadDialog dialog = new ArchitectureAlternativeLoadDialog((Shell) null,
                architectureModelList, selectedModels, false, alternative);

        dialog.create();

        if (dialog.open() == SWT.OK) {
            Command loadArchiAltCommand = new LoadArchiAltCommand(analysisModel, selectedModels, alternative,
                    preparationManager);
            this.mainEditor.handleCommand(loadArchiAltCommand);
        }

        return selectedModels;
    }

    @Override
    public AlternativeAndChangeRequestTuple showSelectArchitectureAlternativeAndChangeRequestDialog(
            MaintainabilityAnalysisModel analysisModel) {

        AlternativeAndChangeRequestTuple result = new AlternativeAndChangeRequestTuple();

        AddAnalysisInstanceAndhangeRequestDialog dialog = new AddAnalysisInstanceAndhangeRequestDialog(this.mainEditor,
                analysisModel, result, this.mainEditor.getArchitectureModelProvider());

        dialog.create();
        dialog.open();

        return result;
    }

    public void openMapElementsToDevelopersDialog(WorkOrganisationModel workorganisation,
            AbstractArchitectureModel architectureModel, Display display, ICommandHandler commandHandler) {
        MapElementsToDevelopersDialog dialog = new MapElementsToDevelopersDialog(display.getActiveShell(),
                workorganisation, architectureModel, commandHandler);
        dialog.create();
        dialog.open();
    }

    public void showSelectAffectedFollowUpComponent() {

    }
}
