package de.fzi.kamp.ui.analysisoverview.providers;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class SummaryTableLabelProvider implements ITableLabelProvider {
    private final static Logger logger = Logger.getLogger(SummaryTableLabelProvider.class);

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {

        if (element instanceof AnalysisInstanceSummaryType) {
            switch (columnIndex) {
            case AnalysisInstanceConstants.SUMMARYTABLE_INDEX_ARCHITECTURE_ALTERNATIVE:
                if ((element!=null)&&(((AnalysisInstanceSummaryType) element).getArchitectureAlternative()!=null)) {
                    return ((AnalysisInstanceSummaryType) element).getArchitectureAlternative().getName();
                } else {
                    return "?";
                }
            case AnalysisInstanceConstants.SUMMARYTABLE_EFFORT_RESULT:
                if (element!=null) {
                    return Double.toString(((AnalysisInstanceSummaryType) element).getAccumulatedEffort()) + " Person Days";
                } else {
                    return "?";
                }
            }
        }
        return null;
    }

    @Override
    public void addListener(ILabelProviderListener listener) {
        // TODO Auto-generated method stub

    }

    @Override
    public void dispose() {
        // TODO Auto-generated method stub

    }

    @Override
    public boolean isLabelProperty(Object element, String property) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public void removeListener(ILabelProviderListener listener) {
        // TODO Auto-generated method stub
    }
}
