package de.fzi.kamp.ui.analysisoverview.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;

public class SummaryTableContentProvider implements IStructuredContentProvider {
    private final static Logger logger = Logger.getLogger(SummaryTableContentProvider.class);

    /**
     * Returns all elements that will occur in the summary table on the analysis overview page.
     */
    @Override
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof MaintainabilityAnalysisModel) {
            return getSummaryAsTableViewerInput((((MaintainabilityAnalysisModel) inputElement).getAnalysisinstances()))
                    .toArray();
        }
        return new Object[] {};
    }

    @Override
    public void dispose() {
        // TODO Auto-generated method stub
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        // TODO Auto-generated method stub
    }

    /**
     * @param list
     * @return Returns a list of all analysis instances occurring in the given maintainability
     *         analysis model and their corresponding accumulated estimated working effort over all
     *         change requests.
     */
    private List<AnalysisInstanceSummaryType> getSummaryAsTableViewerInput(List<?> list) {
        List<AnalysisInstanceSummaryType> usedAlternatives = new ArrayList<AnalysisInstanceSummaryType>();

        for (Iterator<?> listIterator = list.iterator(); listIterator.hasNext();) {
            Object nextElement = listIterator.next();
            if (nextElement instanceof EffortAnalysisInstance) {

                EffortAnalysisInstance instance = (EffortAnalysisInstance) nextElement;

                AnalysisInstanceSummaryType archiAlt = getArchitectureAlternativeFromListIfAvailable(instance,
                        usedAlternatives);
                if (archiAlt != null) {
                    if (instance.getWorkplan() != null && instance.getWorkplan().getTasks().size() > 0) {
                        archiAlt.addEffort(instance.getWorkplan().getTasks().get(0).getAggregatedTimeEstimate());
                    }
                } else {
                    AnalysisInstanceSummaryType newTypeForSummary = new AnalysisInstanceSummaryType(instance);
                    usedAlternatives.add(newTypeForSummary);
                }
            }
        }

        return usedAlternatives;
    }

    /**
     * 
     * @param instance
     * @param usedAlternatives
     * @return If the architectural alternative contained in the given analysis instance has already
     *         been added to the list of all occurring analysis instances, than the list element is
     *         returned. If it is not contained yet, null is returned.
     */
    private AnalysisInstanceSummaryType getArchitectureAlternativeFromListIfAvailable(EffortAnalysisInstance instance,
            List<AnalysisInstanceSummaryType> usedAlternatives) {

        for (AnalysisInstanceSummaryType type : usedAlternatives) {
            if (type.getArchitectureAlternative().equals(instance.getTargetArchitecturalAlternative())) {
                return type;
            }
        }
        return null;
    }
}
