package de.fzi.kamp.ui.analysisoverview.providers;

import org.apache.log4j.Logger;

import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;

public class AnalysisInstanceSummaryType {
    private final static Logger logger = Logger.getLogger(AnalysisInstanceSummaryType.class);

    ArchitecturalAlternative archiAlternative = null;
    double accumulatedEffort = 0.0;

    public AnalysisInstanceSummaryType(EffortAnalysisInstance instance) {
        super();
        this.archiAlternative = instance.getTargetArchitecturalAlternative();
        if (instance.getWorkplan() != null && instance.getWorkplan().getTasks().size() > 0) {
            this.accumulatedEffort = instance.getWorkplan().getTasks().get(0).getAggregatedTimeEstimate();
        } else {
            this.accumulatedEffort = 0.0;
        }

    }

    public void addEffort(double effort) {
        this.accumulatedEffort += effort;
    }

    public double getAccumulatedEffort() {
        return this.accumulatedEffort;
    }

    public ArchitecturalAlternative getArchitectureAlternative() {
        return this.archiAlternative;
    }
}
