package de.fzi.kamp.ui.analysisoverview.providers;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;

public class AnalysisInstanceLabelProvider implements ITableLabelProvider {
    private final static Logger logger = Logger.getLogger(AnalysisInstanceLabelProvider.class);

    @Override
    public Image getColumnImage(Object element, int columnIndex) {

        return null;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof EffortAnalysisInstance) {
            switch (columnIndex) {
            case AnalysisInstanceConstants.MAINTABLECOLUMN_INDEX_ARCHITECTURE_ALTERNATIVE:
                if ((element != null)&&((EffortAnalysisInstance) element).getTargetArchitecturalAlternative()!=null) {
                    return ((EffortAnalysisInstance) element).getTargetArchitecturalAlternative().getName();
                } else {
                    return "?";
                }
            case AnalysisInstanceConstants.MAINTABLECOLUMN_INDEX_CHANGE_REQUEST:
                if ((element != null)&&((EffortAnalysisInstance) element).getChangerequest()!=null) {
                    return ((EffortAnalysisInstance) element).getChangerequest().getName();
                } else {
                    return "?";
                }
            case AnalysisInstanceConstants.MAINTABLECOLUMN_INDEX_RESULT_SUMMARY:
                if (element != null) {
                    if (((EffortAnalysisInstance) element).getWorkplan() != null
                            && ((EffortAnalysisInstance) element).getWorkplan().getTasks().size() > 0) {
                        return Double.toString(((EffortAnalysisInstance) element).getWorkplan().getTasks().get(0)
                                .getAggregatedTimeEstimate())
                                + " Person Days";
                    } else
                        return "0.0 Person Days";
                } else {
                    return "?";
                }
            default:
                break;
            }
        }
        return null;
    }

    @Override
    public void addListener(ILabelProviderListener listener) {
        // TODO Auto-generated method stub

    }

    @Override
    public void dispose() {
        // TODO Auto-generated method stub

    }

    @Override
    public boolean isLabelProperty(Object element, String property) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public void removeListener(ILabelProviderListener listener) {
        // TODO Auto-generated method stub

    }
}
