package de.fzi.kamp.ui.analysisoverview.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;

public class ShowResultSummaryButtonListener extends AnalysisInstanceButtonListener {
    private final static Logger logger = Logger.getLogger(ShowResultSummaryButtonListener.class);

    public ShowResultSummaryButtonListener(IAnalysisInstanceManager instanceManager, EffortAnalysisInstance instance,
            IMainEditor editor) {
        super(instanceManager, instance, editor);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (getInstance() != null)
            getInstanceManager().showResultSummary(getInstance());

    }

}
