package de.fzi.kamp.ui.analysisoverview.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.maineditor.page.CentralEditorPage;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;

public class EditWorkplanButtonListener extends AnalysisInstanceButtonListener {
    private final static Logger logger = Logger.getLogger(EditWorkplanButtonListener.class);

    private IMainEditor mainEditor;

    public EditWorkplanButtonListener(IAnalysisInstanceManager instanceManager, EffortAnalysisInstance instance,
            IMainEditor editor) {
        super(instanceManager, instance, editor);
        this.mainEditor = editor;

    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        if (getInstance() != null) {
            this.mainEditor.getCentralPage().setAddCompositeActivityButtonVisible();
            getInstanceManager().editWorkPlanForAnalysisInstance(getInstance(), getEditor());
            ((CentralEditorPage) this.mainEditor.getCentralPage()).getWorkplanLayer().setIsEditableEffort(false);
            ((CentralEditorPage) this.mainEditor.getCentralPage()).getWorkplanLayer().showEffortEstimationColumns();
        }
    }
}
