package de.fzi.kamp.ui.analysisoverview.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.WorkplanFactory;

public class DeriveButtonListener extends AnalysisInstanceButtonListener {
    private final static Logger logger = Logger.getLogger(DeriveButtonListener.class);

    public DeriveButtonListener(IAnalysisInstanceManager instanceManager, EffortAnalysisInstance instance,
            IMainEditor editor) {

        super(instanceManager, instance, editor);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        EffortAnalysisInstance analysisInstance = getInstance();

        if (analysisInstance != null) {

        	//This case should not happen, because Workplan has been created when
        	//analysis instance has been created in AnalysisInstanceManager
            if (analysisInstance.getWorkplan() == null) {

                Workplan workplan = WorkplanFactory.eINSTANCE.createWorkplan();

                analysisInstance.setWorkplan(workplan);
            }
            getInstanceManager().deriveWorkplanForAnalysisInstance(getInstance(), getEditor());
        }
    }
}
