package de.fzi.kamp.ui.analysisoverview.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;

public class AnalysisInstanceRemoveArchitectureSelectionListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(AnalysisInstanceRemoveArchitectureSelectionListener.class);

    private AnalysisManager manager;
    private Table table;

    public AnalysisInstanceRemoveArchitectureSelectionListener(AnalysisManager manager, Table table) {
        super();
        this.table = table;
        this.manager = manager;
    }

    public void widgetSelected(SelectionEvent e) {

        TableItem[] items = table.getSelection();
        if (items.length > 0)
            manager.getAnalysisInstanceManager().removeAnalysisInstance((EffortAnalysisInstance) items[0].getData(),
                    items[0]);

        table.update();
    }

}
