package de.fzi.kamp.ui.analysisoverview.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;

import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;

public class AnalysisInstanceButtonListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(AnalysisInstanceButtonListener.class);

    private EffortAnalysisInstance instance;
    private IAnalysisInstanceManager instanceManager;
    private IMainEditor editor;

    public AnalysisInstanceButtonListener(IAnalysisInstanceManager instanceManager, EffortAnalysisInstance instance,
            IMainEditor editor) {
        super();
        this.instance = instance;
        this.instanceManager = instanceManager;
        this.editor = editor;

    }

    public IAnalysisInstanceManager getInstanceManager() {
        return instanceManager;
    }

    public EffortAnalysisInstance getInstance() {
        return instance;
    }

    public IMainEditor getEditor() {
        return editor;
    }
}
