package de.fzi.kamp.ui.analysisoverview.dialog.dialoglisteners;

import org.apache.log4j.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Combo;

import de.fzi.kamp.ui.analysisoverview.dialog.AddAnalysisInstanceAndhangeRequestDialog;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;

public class ChangeRequestComboListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(ChangeRequestComboListener.class);

    private Combo architectureAlternativeCombo;
    private Combo changeRequestCombo;
    private Combo startingModelCombo;
    private MaintainabilityAnalysisModel analysisModel;
    private AddAnalysisInstanceAndhangeRequestDialog analysisInstanceAddingDialog;
    private SelectionAdapter startingModelListener;

    /**
     * This listener just enables or disables the starting model combo depending on whether the an
     * change request with or without automation is chosen.
     * 
     * @param changeRequestCombo
     * @param startingModelCombo
     * @param analysisModel
     * @param startingModelListener 
     */
    public ChangeRequestComboListener(Combo architectureAlternativeCombo, Combo changeRequestCombo,
            Combo startingModelCombo, MaintainabilityAnalysisModel analysisModel,
            AddAnalysisInstanceAndhangeRequestDialog analysisInstanceAddingDialog, SelectionAdapter startingModelListener) {
        this.architectureAlternativeCombo = architectureAlternativeCombo;
        this.startingModelCombo = startingModelCombo;
        this.changeRequestCombo = changeRequestCombo;
        this.analysisModel = analysisModel;
        this.analysisInstanceAddingDialog = analysisInstanceAddingDialog;
        this.startingModelListener = startingModelListener;

        // this.logger = Logger.getRootLogger();
        // SimpleLayout layout = new SimpleLayout();
        // ConsoleAppender consoleAppender = new ConsoleAppender( layout );
        // this.logger.addAppender( consoleAppender );
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        int selectionIndex = this.changeRequestCombo.getSelectionIndex();
        ChangeRequest selectedChangeRequest = this.analysisModel.getChangerequests().get(selectionIndex);

        if (selectedChangeRequest != null) {
            if (selectedChangeRequest.isAutomaticDerivation()) {
                this.startingModelCombo.setEnabled(true);
                int archiAltSelectionIndex = this.architectureAlternativeCombo.getSelectionIndex();
                ArchitecturalAlternative selectedArchiAlt = this.analysisModel.getArchitecturealternatives().get(
                        archiAltSelectionIndex);
                this.analysisInstanceAddingDialog.fillStartingModelComboWithParentModels(selectedArchiAlt);
                if(this.startingModelCombo.getItemCount() > 0){
                	this.startingModelCombo.select(0);
                	this.startingModelCombo.notifyListeners(SWT.Selection, null);
                	//this.startingModelListener.widgetSelected(null);
                }                
            } else {
                this.startingModelCombo.setEnabled(false);
            }
        }
    }
}
