package de.fzi.kamp.ui.analysisoverview.dialog;

import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import de.fzi.kamp.service.analysisinstance.AlternativeAndChangeRequestTuple;
import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.architecturemodel.impl.BackboneModelLoader;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.analysisoverview.dialog.dialoglisteners.ArchitectureModelComboListener;
import de.fzi.kamp.ui.analysisoverview.dialog.dialoglisteners.ChangeRequestComboListener;
import de.fzi.kamp.ui.analysisoverview.dialog.dialoglisteners.StartingModelComboListener;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;

public class AddAnalysisInstanceAndhangeRequestDialog extends Dialog {
    private final static Logger logger = Logger.getLogger(AddAnalysisInstanceAndhangeRequestDialog.class);

    private MaintainabilityAnalysisModel analysisModel;
    private Combo comboAlternatives;
    private Combo comboChangeRequests;
    private Combo comboForStartingModel;
    private AlternativeAndChangeRequestTuple result;
    private IArchitectureModelProvider architectureModelProvider;
    private List<IQAlternative> parentAlternativesOfSelectedAlternative;
    private IMainEditor mainEditor;

    // Is set in the listener of the starting model combo
    private IQAlternative sourceIQAlternative;

    public AddAnalysisInstanceAndhangeRequestDialog(IMainEditor mainEditor, MaintainabilityAnalysisModel analysisModel,
            AlternativeAndChangeRequestTuple result, IArchitectureModelProvider architectureModelProvider) {
        super(mainEditor.getMainEditorShell());
        this.mainEditor = mainEditor;
        this.analysisModel = analysisModel;
        this.result = result;
        this.architectureModelProvider = architectureModelProvider;
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Choose Analysis Instance");

        // center the shell and set width and height
        Rectangle rec = shell.getDisplay().getBounds();
        int shellWidth = 320;
        int shellHeight = 270;
        int indentionLeft = (rec.width - shellWidth) / 2;
        int indentionTop = (rec.height - shellHeight) / 2;
        shell.setBounds(indentionLeft, indentionTop, shellWidth, shellHeight);

    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);

        Composite area = (Composite) this.getDialogArea();
        setLayout(area);

        // create the combo for the architecture models
        createLabel(area, "Architecture Alternative (target model):");
        this.comboAlternatives = new Combo(area, SWT.READ_ONLY);
        setLayoutData(this.comboAlternatives);
        for (ArchitecturalAlternative alternative : this.analysisModel.getArchitecturealternatives()) {
            this.comboAlternatives.add(alternative.getName());
        }
        if(this.comboAlternatives.getItemCount() > 0){
        	this.comboAlternatives.select(0);
        }

        // create the combo displaying the existing change requests
        createLabel(area, "Change Request:");
        this.comboChangeRequests = new Combo(area, SWT.READ_ONLY);
        setLayoutData(this.comboChangeRequests);
        for (ChangeRequest changeRequest : this.analysisModel.getChangerequests()) {
            if (changeRequest.isAutomaticDerivation()) {
                this.comboChangeRequests.add(changeRequest.getName() + " (automated)");
            } else {
                this.comboChangeRequests.add(changeRequest.getName());
            }
        }

        createLabel(area, "Source model");
        this.comboForStartingModel = new Combo(area, SWT.READ_ONLY);
        this.comboForStartingModel.setEnabled(false); // In the beginning this combo is disabled.
        // If an change request with automation is chosen,
        // then the combo is enabled.
        setLayoutData(this.comboForStartingModel);
        // fill the combo with all possible starting models
        // depending on the selected architecture model

        
        // Adding all listeners
        SelectionAdapter startingModelListener = new StartingModelComboListener(this.comboForStartingModel, this);
        this.comboForStartingModel.addSelectionListener(startingModelListener);

        ChangeRequestComboListener changeRequestComboListener = new ChangeRequestComboListener(this.comboAlternatives,
                this.comboChangeRequests, this.comboForStartingModel, this.analysisModel, this, startingModelListener);
        this.comboChangeRequests.addSelectionListener(changeRequestComboListener);
        this.comboAlternatives.addSelectionListener(new ArchitectureModelComboListener(changeRequestComboListener));

        
        if(this.comboChangeRequests.getItemCount() > 0){
        	this.comboChangeRequests.select(0);
        	this.comboChangeRequests.notifyListeners(SWT.Selection, null);
        	//changeRequestComboListener.widgetSelected(null);
        }
        
//        if (this.comboForStartingModel.getItemCount() > 0) {
//            this.comboChangeRequests.getItem(this.comboChangeRequests.getSelectionIndex());
//            this.comboForStartingModel.setEnabled(true);
//            this.comboForStartingModel.select(0);
//            startingModelListener.widgetSelected(null);
//        }

        return control;
    }

    @Override
    protected void okPressed() {

        int selectionIndexTargetAlternative = this.comboAlternatives.getSelectionIndex();
        this.result.targetArchitectureAlternative = this.analysisModel.getArchitecturealternatives().get(selectionIndexTargetAlternative);

        int selectionIndexCR = this.comboChangeRequests.getSelectionIndex();
        this.result.changeRequest = this.analysisModel.getChangerequests().get(selectionIndexCR);

        if (this.result.changeRequest.isAutomaticDerivation()) {
            if (this.parentAlternativesOfSelectedAlternative != null
                    && this.parentAlternativesOfSelectedAlternative.size() > 0) {

                /**
                 * in case of automatic derivation we assign source and target alternatives properly (source = parent, target = child)
                 */
                if (this.sourceIQAlternative != null) {
                    ArchitecturalAlternative sourceAlternative 
                        = BackboneModelLoader.lookupArchitecturalAlternativeForIQAlternative(this.sourceIQAlternative, this.analysisModel.getArchitecturealternatives());
                    if (sourceAlternative != null) {
                        result.sourceArchitectureAlternative = sourceAlternative;
                    }
                }
            }
        }
        super.okPressed();
    }

    private void createLabel(Composite parent, String text) {

        Label label = new Label(parent, SWT.NONE);
        label.setText(text);

    }

    private void setLayout(Composite comp) {

        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        comp.setLayout(gl);
    }

    private void setLayoutData(Combo combo) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = SWT.FILL;
        combo.setLayoutData(gd);
    }

    public void fillStartingModelComboWithParentModels(ArchitecturalAlternative selectedArchiAlt) {
        IQModel iQModelOfSelectedModel = BackboneModelLoader.findIQModelForAlternativeName(selectedArchiAlt.getName(),
                this.mainEditor);
        if (iQModelOfSelectedModel != null) {
            this.parentAlternativesOfSelectedAlternative = new LinkedList<IQAlternative>();
            IQElement possibleParentAlternative = iQModelOfSelectedModel.getAlternative().getParent();
            fillParentModelList(this.parentAlternativesOfSelectedAlternative, possibleParentAlternative);
            this.comboForStartingModel.removeAll();
            for (IQAlternative parent : this.parentAlternativesOfSelectedAlternative) {
                this.comboForStartingModel.add(parent.getInfo().getDescription());
            }
        }        
    }

    /**
     * Searches recursively after parent alternatives of the chosen model.
     * 
     * @param parentAlternatives
     * @param possibleParentAlternative
     */
    private void fillParentModelList(List<IQAlternative> parentAlternatives, IQElement possibleParentAlternative) {
        if (possibleParentAlternative instanceof IQAlternative) {
            parentAlternatives.add((IQAlternative) possibleParentAlternative);
            if (possibleParentAlternative.getParent() != null)
                fillParentModelList(parentAlternatives, possibleParentAlternative.getParent());
        }        
    }

    public void setSourceIQModel(int selectionIndex) {
        this.sourceIQAlternative = this.parentAlternativesOfSelectedAlternative.get(selectionIndex);
    }
}