package de.fzi.kamp.ui.analysisoverview.adapters;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import de.fzi.kamp.ui.analysisoverview.providers.AnalysisInstanceConstants;
import de.fzi.maintainabilitymodel.main.MainPackage;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;

public class SummaryTableContentAdapter extends EContentAdapter {
    private final static Logger logger = Logger.getLogger(SummaryTableContentAdapter.class);

    private Table table;
    private TableViewer tableViewer;

    public SummaryTableContentAdapter(Table table, TableViewer tableViewer) {
        super();
        this.table = table;
        this.tableViewer = tableViewer;

        update();
    }

    /**
     * If there are changes in the analysis instances or their metrics, the table for the summary of
     * the estimated effort is updated.
     */
    @Override
    public void notifyChanged(Notification notification) {
        if (notification.getFeatureID(MaintainabilityAnalysisModel.class) == MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ANALYSISINSTANCES
                || notification.getFeatureID(MaintainabilityAnalysisModel.class) == MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__METRICS) {
            update();
        }
        super.notifyChanged(notification);
    }

    /**
     * updates the table viewer and columns of the effort summary table on the analysis overview
     * page.
     */
    private void update() {

        if (!table.isDisposed()) {
            this.tableViewer.refresh();
            table.pack();
            table.redraw();

            for (TableColumn c : table.getColumns()) {
                c.pack();
                if (c.getText().equals(AnalysisInstanceConstants.SUMMARYTABLE_CAPTION_EFFORT_SUMMARY)) {
                    c.setAlignment(SWT.CENTER);
                }
            }
        }
    }
}