package de.fzi.kamp.ui.analysisoverview.adapters;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.swt.widgets.Button;

import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;

public class AnalysisInstanceItemAdapter implements Adapter {
    private final static Logger logger = Logger.getLogger(AnalysisInstanceItemAdapter.class);

    private Button deriveWorkplanButton;
    private Button editWorkplanButton;
    private Button calculateWorkcomplexityButton;
    private Button effortEstimationInterviewButton;
    private Button effortEstimationEditButton;
    private Button showResultSummaryButton;
    private IAnalysisInstanceManager analysisInstanceManager;
    private EffortAnalysisInstance analysisInstance;
    private Notifier target;

    public AnalysisInstanceItemAdapter(IAnalysisInstanceManager analysisInstanceManager,
            EffortAnalysisInstance analysisInstance) {
        super();
        this.analysisInstanceManager = analysisInstanceManager;
        this.analysisInstance = analysisInstance;
    }

    @Override
    public Notifier getTarget() {
        return target;
    }

    @Override
    public boolean isAdapterForType(Object type) {
        if (type instanceof EffortAnalysisInstance) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public void notifyChanged(Notification notification) {

        /*
         * Checking the interview button, the work complexity button and the result summary button
         * is commented out to avoid null pointer exceptions, because all buttons are is blanked
         * out.
         */
        if (analysisInstance != null) {
            checkWorkplanDeriveButton();
            checkWorkplanEditButton();
            // checkCalculateWorkcomplexityButton();
            // checkEffortEstimationInterviewButton();
            checkEffortEstimationEditButton();
            // checkShowResultSummaryButton();
        }
    }

    public void manualUpdateAfterautomaticDerivation() {
        if (this.analysisInstance != null) {
            checkWorkplanDeriveButton();
            checkWorkplanEditButton();
            checkEffortEstimationEditButton();
        }
    }

    private void checkWorkplanDeriveButton() {
        boolean enabled = this.analysisInstanceManager.isEnabledDeriveWorkPlanForAnalysisInstance(analysisInstance);
        if (!this.deriveWorkplanButton.isDisposed())
            this.deriveWorkplanButton = setEnablementOfButton(this.deriveWorkplanButton, enabled);
    }

    private void checkWorkplanEditButton() {
        boolean enabled = this.analysisInstanceManager.isEnabledEditWorkPlanForAnalysisInstance(analysisInstance);
        if (!this.editWorkplanButton.isDisposed())
            this.editWorkplanButton = setEnablementOfButton(this.editWorkplanButton, enabled);
    }

    // temporarily not used
    private void checkCalculateWorkcomplexityButton() {
        boolean enabled = this.analysisInstanceManager
                .isEnabledCalculateWorkComplexityForAnalysisInstance(analysisInstance);
        if (!this.calculateWorkcomplexityButton.isDisposed())
            this.calculateWorkcomplexityButton = setEnablementOfButton(this.calculateWorkcomplexityButton, enabled);
    }

    // temporarily not used
    private void checkEffortEstimationInterviewButton() {
        boolean enabled = this.analysisInstanceManager.isEnabledStartEffortEstimationInterview(analysisInstance);
        if (!this.effortEstimationInterviewButton.isDisposed())
            this.effortEstimationInterviewButton = setEnablementOfButton(this.effortEstimationInterviewButton, enabled);
    }

    private void checkEffortEstimationEditButton() {
        boolean enabled = this.analysisInstanceManager.isEnabledEditEffortEstimates(analysisInstance);
        if (!this.effortEstimationEditButton.isDisposed())
            this.effortEstimationEditButton = setEnablementOfButton(this.effortEstimationEditButton, enabled);
    }

    // temporarily not used
    private void checkShowResultSummaryButton() {
        boolean enabled = this.analysisInstanceManager.isEnabledShowResultSummary(analysisInstance);
        if (!this.showResultSummaryButton.isDisposed())
            this.showResultSummaryButton = setEnablementOfButton(this.showResultSummaryButton, enabled);
    }

    private Button setEnablementOfButton(Button button, boolean enabled) {
        if (button != null) {
            button.setEnabled(enabled);
        }
        return button;
    }

    @Override
    public void setTarget(Notifier newTarget) {
        this.target = newTarget;
    }

    public void setDeriveWorkplanButton(Button deriveWorkplan) {
        this.deriveWorkplanButton = deriveWorkplan;
        this.checkWorkplanDeriveButton();
    }

    public void setEditWorkspaceButton(Button editWorkspaceButton) {
        this.editWorkplanButton = editWorkspaceButton;
        this.checkWorkplanEditButton();
    }

    public void setCalculateWorkcomplexityButton(Button calculateWorkcomplexityButton) {
        this.calculateWorkcomplexityButton = calculateWorkcomplexityButton;
        this.checkCalculateWorkcomplexityButton();
    }

    public void setEffortEstimationInterviewButton(Button effortEstimationInterviewButton) {
        this.effortEstimationInterviewButton = effortEstimationInterviewButton;
        this.checkEffortEstimationInterviewButton();
    }

    public void setEffortEstimationEditButton(Button effortEstimationEditButton) {
        this.effortEstimationEditButton = effortEstimationEditButton;
        this.checkEffortEstimationEditButton();
    }

    public void setShowResultSummaryButton(Button showResultSummaryButton) {
        this.showResultSummaryButton = showResultSummaryButton;
        this.checkShowResultSummaryButton();
    }

    public void setAnalysisInstanceManager(IAnalysisInstanceManager analysisInstanceManager) {
        this.analysisInstanceManager = analysisInstanceManager;
    }

    public void setAnalysisInstance(EffortAnalysisInstance analysisInstance) {
        this.analysisInstance = analysisInstance;
    }

}
