package de.fzi.kamp.ui.analysisoverview.adapters;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.analysisoverview.listeners.CalculateButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.DeriveButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.EditEffortEstimationButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.EditWorkplanButtonListener;
import de.fzi.kamp.ui.analysisoverview.providers.AnalysisInstanceConstants;
import de.fzi.kamp.ui.general.ActivityImageProvider;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.maineditor.stacklayers.AnalysisInstanceLayer;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.main.MainPackage;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;

public class AnalysisInstanceContentAdapter extends EContentAdapter {
    private final static Logger logger = Logger.getLogger(AnalysisInstanceContentAdapter.class);

    private Table table;
    private List<TableEditor> tableEditorList;
    private IAnalysisInstanceManager manager;
    private TableViewer tableViewer;
    private SurfaceFactory surfaceFactory;
    private IMainEditor editor;

    private AnalysisInstanceLayer analysisInstanceLayer;

    public AnalysisInstanceContentAdapter(Table table, TableViewer tableViewer, IAnalysisInstanceManager manager,
            IMainEditor editor, AnalysisInstanceLayer analysisInstanceLayer) {
        super();
        this.table = table;
        this.editor = editor;
        this.manager = manager;
        this.tableViewer = tableViewer;
        this.tableEditorList = new LinkedList<TableEditor>();
        this.surfaceFactory = new SurfaceFactory();
        this.analysisInstanceLayer = analysisInstanceLayer;

        update();
    }

    @Override
    public void notifyChanged(Notification notification) {

        if (notification == null) {
            update();
        } else {

            if (notification.getFeatureID(MaintainabilityAnalysisModel.class) == MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ANALYSISINSTANCES
                    || notification.getFeatureID(MaintainabilityAnalysisModel.class) == MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__METRICS) {
                update();
            }
        }
        super.notifyChanged(notification);
    }

    private void update() {
        disposeTableEditors();

        if (!this.table.isDisposed()) {
            this.tableViewer.refresh();

            for (TableItem item : this.table.getItems()) {
                this.tableEditorList = this.addButtonsToOverviewTable(item, this.manager, this, this.editor);
            }
    
            for (TableColumn c : table.getColumns()) {
                c.pack();
                if (c.getText().equals(AnalysisInstanceConstants.MAINTABLECOLUMN_CAPTION_RESULT_SUMMARY))
                    c.setWidth(130);
            }
        }
        
        layoutTableEditors();
    }

    private void disposeTableEditors() {
        for (TableEditor tableEditor : tableEditorList) {

            if (tableEditor.getEditor() != null)
                tableEditor.getEditor().dispose();
            if (tableEditor.getItem() != null)
                tableEditor.getItem().dispose();

            tableEditor.dispose();
        }
        this.tableEditorList = new ArrayList<TableEditor>();
    }
    
    public void layoutTableEditors() {
        for (TableEditor tableEditor : tableEditorList) {
            if (!tableEditor.getEditor().isDisposed()) {
                tableEditor.layout();
            }
        }
    }

    public List<TableEditor> getTableEditorList() {
        return tableEditorList;
    }

    public List<TableEditor> addButtonsToOverviewTable(TableItem item, IAnalysisInstanceManager manager,
            AnalysisInstanceContentAdapter contentAdapter, IMainEditor editor) {
        List<TableEditor> tableEditorList = new ArrayList<TableEditor>();
        if (item.getData() instanceof EffortAnalysisInstance) {
            EffortAnalysisInstance analysisInstance = (EffortAnalysisInstance) item.getData();

            AnalysisInstanceItemAdapter itemadapter = new AnalysisInstanceItemAdapter(manager, analysisInstance);
            analysisInstance.eAdapters().add(itemadapter);

            tableEditorList.add(createWorkPlanButtons(item, AnalysisInstanceConstants.MAINTABLECOLUMN_INDEX_WORKPLAN,
                    item.getParent(), manager, contentAdapter, analysisInstance, itemadapter, editor));

            // tableEditorList.add(createWorkComplexityButton(item, 6, item.getParent(), manager,
            // itemadapter, analysisInstance, editor));
            // not used at the moment

            tableEditorList.add(createEffortEstimationButtons(item,
                    AnalysisInstanceConstants.MAINTABLECOLUMN_INDEX_EFFORT_ESTIMATION, item.getParent(), manager,
                    itemadapter, analysisInstance, editor));
            // tableEditorList.add(createResultSummaryButton(item, 5, table, manager, itemadapter,
            // instance, editor));
            // Show result button temporarily blanked out to be replaced by accumulated effort
            // value.
            
            
            
        }
        return tableEditorList;
    }
    
    private TableEditor createWorkPlanButtons(TableItem item, int column, Table table,
            IAnalysisInstanceManager manager, AnalysisInstanceContentAdapter contentAdapter,
            EffortAnalysisInstance instance, AnalysisInstanceItemAdapter itemadapter, IMainEditor mainEditor) {

        TableEditor editor = new TableEditor(table);
        Composite comp = surfaceFactory.createButtonComposite(table);

        Button derive = surfaceFactory.createButton(comp, ActivityImageProvider.getRunIcon(), new DeriveButtonListener(manager, instance, mainEditor));
        derive.setToolTipText("Click here to derive workplan. If Change Request is marked as \n" +
        		"\"automatic derivation\", then the workplan is created automatically.");
        Button edit = surfaceFactory.createButton(comp, ActivityImageProvider.getIconForEditButton(), 
                            new EditWorkplanButtonListener(manager, instance, mainEditor));
        edit.setToolTipText("Click here to edit the workplan of this analysis instance.");

        itemadapter.setDeriveWorkplanButton(derive);
        itemadapter.setEditWorkspaceButton(edit);

        editor.setEditor(comp, item, column);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.layout();

        return editor;
    }
    
    private TableEditor createEffortEstimationButtons(TableItem item, int column, Table table,
            IAnalysisInstanceManager manager, AnalysisInstanceItemAdapter itemadapter, EffortAnalysisInstance instance,
            IMainEditor mainEditor) {

        TableEditor editor = new TableEditor(table);
        Composite comp = surfaceFactory.createButtonComposite(table);
        
        this.analysisInstanceLayer.getWidgets().add(comp);
        /*
         * Interview button is temporarily blanked out.
         */
        // Button interviewButton = createButton(comp, "Interview", new
        // EffortEstimationInterviewButtonListener(manager, instance, mainEditor));
        // interviewButton.setEnabled(false);
        Button editButton = surfaceFactory.createButton(comp, ActivityImageProvider.getIconForEditButton(), 
                            new EditEffortEstimationButtonListener(manager, instance, mainEditor));
        editButton.setToolTipText("Click here to edit your effort estimation for this analysis instance.");
        editButton.setEnabled(false);
        this.analysisInstanceLayer.getWidgets().add(editButton);

        // itemadapter.setEffortEstimationInterviewButton(interviewButton);
        itemadapter.setEffortEstimationEditButton(editButton);

        editor.setEditor(comp, item, column);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.layout();

        return editor;
    }
    
    private TableEditor createWorkComplexityButton(TableItem item, int column, Table table,
            IAnalysisInstanceManager manager, AnalysisInstanceItemAdapter itemadapter, EffortAnalysisInstance instance,
            IMainEditor mainEditor) {

        Composite comp = surfaceFactory.createButtonComposite(table);
        Button button = surfaceFactory.createButton(comp, "Calculate", new CalculateButtonListener(manager, instance, mainEditor));
        button.setEnabled(false);
        itemadapter.setCalculateWorkcomplexityButton(button);
        this.analysisInstanceLayer.getWidgets().add(comp);
        this.analysisInstanceLayer.getWidgets().add(button);

        TableEditor editor = new TableEditor(table);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        
        editor.setEditor(comp, item, column);
        editor.layout();

        return editor;
    }
}
