package de.fzi.kamp.service.workplanmanagement;

import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;

import de.fzi.maintainabilitymodel.activity.adaptation.ChangeComponentImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeDataTypeActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceDefinitionActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeOperationImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.RemoveComponentActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.RemoveInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.RemoveOperationImplementationActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementComponentActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementOperationActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementProvidedInterfaceportActivity;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractComponent;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractDatatype;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractInterface;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractInterfacePort;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractOperationImplementation;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationImplementationSelectionContainer;

public class WorkplanDerivationManager {
    private final static Logger logger = Logger.getLogger(WorkplanDerivationManager.class);

    private CompositeTaskDerivationContainer workplanContainer;

    public WorkplanDerivationManager(CompositeTaskDerivationContainer workplanContainer) {
        this.workplanContainer = workplanContainer;
    }

    public void addShowedComponent(ComponentSelectionContainer component) {
        if (!this.workplanContainer.getLastShownComponentContainers().contains(component))
            this.workplanContainer.getLastShownComponentContainers().add(component);
    }

    public void removeShowedComponent(ComponentSelectionContainer component) {
        if (this.workplanContainer.getLastShownComponentContainers().contains(component))
            this.workplanContainer.getLastShownComponentContainers().remove(component);
    }

    public void addShowedInterfacePort(InterfacePortSelectionContainer interfaceContainer) {

        if (!this.workplanContainer.getLastShownInterfaceportContainers().contains(interfaceContainer))
            this.workplanContainer.getLastShownInterfaceportContainers().add(interfaceContainer);
    }

    public void removeShowedInterfacePort(InterfacePortSelectionContainer interfaceContainer) {
        if (this.workplanContainer.getLastShownInterfaceportContainers().contains(interfaceContainer))
            this.workplanContainer.getLastShownInterfaceportContainers().remove(interfaceContainer);
    }

//    public void addShowedOperation(OperationSelectionContainer operationContainer) {
//        if (!this.workplanContainer.getLastShownOperationSelectionContainer().contains(operationContainer))
//            this.workplanContainer.getLastShownOperationSelectionContainer().add(operationContainer);
//    }
//
//    public void removeShowedOperation(OperationSelectionContainer operationContainer) {
//        if (this.workplanContainer.getLastShownOperationSelectionContainer().contains(operationContainer))
//            this.workplanContainer.getLastShownOperationSelectionContainer().remove(operationContainer);
//    }

    public void addShowedInterface(InterfaceSelectionContainer iface) {
        if (!this.workplanContainer.getLastShownInterfaceContainers().contains(iface))
            this.workplanContainer.getLastShownInterfaceContainers().add(iface);
    }

    public void removeShowedInterface(InterfaceSelectionContainer iface) {
        if (this.workplanContainer.getLastShownInterfaceContainers().contains(iface))
            this.workplanContainer.getLastShownInterfaceContainers().remove(iface);
    }

    public void addShowedDatatype(DataTypeSelectionContainer datatypeContainer) {
        if (!this.workplanContainer.getLastShownDataTypeSelectionContainers().contains(datatypeContainer))
            this.workplanContainer.getLastShownDataTypeSelectionContainers().add(datatypeContainer);
    }

    public void removeShowedDatatype(DataTypeSelectionContainer datatypeContainer) {
        if (this.workplanContainer.getLastShownDataTypeSelectionContainers().contains(datatypeContainer))
            this.workplanContainer.getLastShownDataTypeSelectionContainers().remove(datatypeContainer);
    }

    public List<ComponentSelectionContainer> getSelectedComponents() {

        List<ComponentSelectionContainer> result = new LinkedList<ComponentSelectionContainer>();

        for (ComponentSelectionContainer componentSelectionContainer : this.workplanContainer.getComponentContainers()) {

            if (componentSelectionContainer.isSelected()) {
                result.add(componentSelectionContainer);
            }
        }

        return result;
    }

    public List<InterfacePortSelectionContainer> getSelectedInterfacePorts() {

        List<InterfacePortSelectionContainer> selectedInterfaces = new LinkedList<InterfacePortSelectionContainer>();

        for (InterfacePortSelectionContainer interfacePortSelectionContainer : this.workplanContainer
                .getInterfacePortSelectionContainer()) {
            if (interfacePortSelectionContainer.isSelected()) {
                selectedInterfaces.add(interfacePortSelectionContainer);
            }
        }
        return selectedInterfaces;
    }

//    public List<OperationSelectionContainer> getSelectedOperations() {
//
//        List<OperationSelectionContainer> selectedOperations = new LinkedList<OperationSelectionContainer>();
//
//        for (OperationSelectionContainer operationSelectionContainer : this.workplanContainer
//                .getOperationSelectionContainer()) {
//            if (operationSelectionContainer.isSelected()) {
//                selectedOperations.add(operationSelectionContainer);
//            }
//        }
//        return selectedOperations;
//    }

    public List<InterfaceSelectionContainer> getSelectedInterfaces() {

        List<InterfaceSelectionContainer> selectedInterfaces = new LinkedList<InterfaceSelectionContainer>();

        for (InterfaceSelectionContainer interfaceSelectionContainer : this.workplanContainer
                .getInterfaceSelectionContainers()) {
            if (interfaceSelectionContainer.isSelected()) {
                selectedInterfaces.add(interfaceSelectionContainer);
            }
        }
        return selectedInterfaces;
    }

    public List<DataTypeSelectionContainer> getSelectedDatatypes() {

        List<DataTypeSelectionContainer> selectedDataTypes = new LinkedList<DataTypeSelectionContainer>();

        for (DataTypeSelectionContainer dataTypesSelectionContainer : this.workplanContainer
                .getDataTypeSelectionContainers()) {
            if (dataTypesSelectionContainer.isSelected()) {
                selectedDataTypes.add(dataTypesSelectionContainer);
            }
        }
        return selectedDataTypes;
    }

    public InterfacePortSelectionContainer getContainerForInterfacePort(AbstractInterfacePort interfacePort) {

        for (InterfacePortSelectionContainer container : this.workplanContainer.getInterfacePortSelectionContainer()) {
            if (container.getInterfaceport().getId().equals(interfacePort.getId()))
                return container;
        }
        return null;
    }

    public OperationImplementationSelectionContainer getContainerForOperation(AbstractOperationImplementation operation) {

        for (OperationImplementationSelectionContainer container : this.workplanContainer.getOperationImplementationSelectionContainer()) {
            if (container.getOperation().getId().equals(operation.getId()))
                return container;
        }
        return null;
    }

    public InterfaceSelectionContainer getContainerForInterface(AbstractInterface iface) {
        for (InterfaceSelectionContainer container : this.workplanContainer.getInterfaceSelectionContainers()) {
            if (container.getReferencedInterface().getId().equals(iface.getId()))
                return container;
        }
        return null;
    }

    public void resetLastSelectedLists() {

        this.workplanContainer.getLastShownDataTypeSelectionContainers().clear();
        this.workplanContainer.getLastShownInterfaceContainers().clear();
        this.workplanContainer.getLastShownInterfaceportContainers().clear();
        this.workplanContainer.getLastShownComponentContainers().clear();
        this.workplanContainer.getLastShownOperationSelectionContainer().clear();
    }

    public ComponentSelectionContainer getContainerForComponentType(AbstractComponent type) {

        for (ComponentSelectionContainer container : this.workplanContainer.getComponentContainers()) {
            if (type.getId().equals(container.getComponenttype().getId()))
                return container;
        }
        return null;
    }

    public DataTypeSelectionContainer getContainerForDatatype(AbstractDatatype type) {
        for (DataTypeSelectionContainer container : this.workplanContainer.getDataTypeSelectionContainers()) {
            if (type.getId().equals(container.getType().getId()))
                return container;
        }
        return null;
    }

    // TODO: Replace by switch!!!!
    public AbstractContainer getContainerForTask(Activity activity) {

        // Components
        if (activity instanceof ImplementComponentActivity)
            return this.getContainerForComponentType(((ImplementComponentActivity) activity).getComponent());

        if (activity instanceof ChangeComponentImplementationActivity)
            return this.getContainerForComponentType(((ChangeComponentImplementationActivity) activity).getComponent());

        if (activity instanceof RemoveComponentActivity)
            return this.getContainerForComponentType(((RemoveComponentActivity) activity).getComponent());

        // Interfaces
        if (activity instanceof ChangeInterfaceDefinitionActivity)
            return this.getContainerForInterface(((ChangeInterfaceDefinitionActivity) activity).getAinterface());

        // Datatypes
        if (activity instanceof ChangeDataTypeActivity)
            return this.getContainerForDatatype(((ChangeDataTypeActivity) activity).getDatatype());

        // InterfacePorts
        if (activity instanceof ImplementProvidedInterfaceportActivity)
            return this.getContainerForInterfacePort((((ImplementProvidedInterfaceportActivity) activity)
                    .getInterfaceport()));

        if (activity instanceof ChangeInterfaceportActivity)
            return this.getContainerForInterfacePort((((ChangeInterfaceportActivity) activity).getInterfaceport()));

        if (activity instanceof RemoveInterfaceportActivity)
            return this.getContainerForInterfacePort((((RemoveInterfaceportActivity) activity).getInterfaceport()));

        // Operations
        if (activity instanceof ImplementOperationActivity)
            return this.getContainerForOperation((((ImplementOperationActivity) activity).getOperation()));

        if (activity instanceof ChangeOperationImplementationActivity)
            return this.getContainerForOperation((((ChangeOperationImplementationActivity) activity).getOperation()));

        if (activity instanceof RemoveOperationImplementationActivity)
            return this.getContainerForOperation((((RemoveOperationImplementationActivity) activity).getOperation()));

        return null;
    }
}
