package de.fzi.kamp.service.workplanmanagement;

import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

import de.fzi.kamp.service.commands.AddChangingDomainCommand;
import de.fzi.kamp.service.commands.DeleteActivityFromWorkplanCommand;
import de.fzi.kamp.service.commands.DeriveFirstChangingDomainCommand;
import de.fzi.kamp.service.general.IDialogManager;
import de.fzi.kamp.service.general.IWizardManager;
import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;

public class WorkPlanManager implements IWorkPlanManager {
    private final static Logger logger = Logger.getLogger(WorkPlanManager.class);

    public WorkPlanManager(IDialogManager dialogManager, EffortAnalysisInstance analysisInstance) {
        super();
    }

    @Override
    public void addTopLevelActivity(IMainEditor editor, Tree tree, IWizardManager wizardManager) {

        DeriveFirstChangingDomainCommand command = new DeriveFirstChangingDomainCommand(editor, tree, wizardManager);
        ((ICommandHandler) editor).handleCommand(command);
    }

    @Override
    public void refineSelectedAvtivity(Tree tree, IMainEditor mainEditor, IWizardManager wizardManager) {
        AddChangingDomainCommand command = new AddChangingDomainCommand(tree, mainEditor, wizardManager);
        ((ICommandHandler) mainEditor).handleCommand(command);
    }

    @Override
    public void refineWorkPlanRegardingContainmentRelation() {

        // TODO: show wizard for refinement of activities regarding containment relation

    }

    @Override
    public void refineWorkPlanRegardingFollowUpRelation() {

        // TODO: show wizard for refinement of activities regarding follow-up relation

    }

    @Override
    public void removeWorkActivity(ICommandHandler commandHandler, TreeItem item) {
        DeleteActivityFromWorkplanCommand command = new DeleteActivityFromWorkplanCommand(item);
        commandHandler.handleCommand(command);
    }

    @Override
    public void calculateFollowUpActivities(Tree workplanTree, IWizardManager wizardManager, IMainEditor mainEditor) {
        wizardManager.showCalculateFollowUpsWizard(workplanTree, mainEditor);
    }
}
