package de.fzi.kamp.service.workplanmanagement;

import org.apache.log4j.Logger;

import de.fzi.kamp.derivation.IWorkplanBuilderResolver;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.ToplevelActivity;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;

public class NewWorkplanBuilder  implements IWorkplanBuilderResolver{
	
	private final static Logger logger = Logger.getLogger(NewWorkplanBuilder.class);

    private IMainEditor mainEditor;
    private ActivityCreationSwitch activityCreationSwitch;

    public NewWorkplanBuilder(IMainEditor mainEditor) {
        this.mainEditor = mainEditor;
    }
    
    public void fillTasklistOfWorkplan(CompositeTaskDerivationContainer milestoneContainer, Workplan workplan) {
    	
    	//Root task for workplan has already been created in AnalysisInstanceManager.createWorkplanRoot(...)
    	CompositeTask workplanRootActivity = (CompositeTask) workplan.getTasks().get(0);
    	
    	if(workplanRootActivity != null){
	    	CompositeTask milestoneActivity = (CompositeTask) milestoneContainer.getActivity();
	    	
	        if(!workplanRootActivity.getSubtasks().contains(milestoneActivity)){
	        	workplanRootActivity.getSubtasks().add(milestoneActivity);
	        }
	
	         this.activityCreationSwitch = new ActivityCreationSwitch();
	         
		     for (AbstractContainer topLevelActivityContainer : milestoneContainer.getTopLevelActivityContainer()) {
		    	 if(topLevelActivityContainer.isSelected()){
		    		 ToplevelActivity createdToplevelActivity = (ToplevelActivity) this.activityCreationSwitch.doSwitch(topLevelActivityContainer);
		        	 if(createdToplevelActivity != null){
		        		 milestoneActivity.getSubtasks().add(createdToplevelActivity);
		        	 }
		    	 }            	 
		     }  
    	}
    }

	@Override
	public void showWorkplanChanges(EffortAnalysisInstance instance) {
		 this.mainEditor.notifyAnalysisInstanceAdapter(instance);		
	}
}
