package de.fzi.kamp.service.workplanmanagement;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.activity.implementation.ImplementComponentActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementDataTypeActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementProvidedInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.implementation.util.ImplementationSwitch;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;

public class ImplementationRemovalSwitch extends ImplementationSwitch<Object> {
    private final static Logger logger = Logger.getLogger(ImplementationRemovalSwitch.class);

    private Object elementToRemove;

    @Override
    public Object caseImplementComponentActivity(ImplementComponentActivity object) {
        object.getRefinements().remove((Activity) this.elementToRemove);
        setReferenceNull((Activity) this.elementToRemove);

        return object;
    }

    @Override
    public Object caseImplementDataTypeActivity(ImplementDataTypeActivity object) {
        // TODO: What's here??
        return object;
    }

    @Override
    public Object caseImplementProvidedInterfaceportActivity(ImplementProvidedInterfaceportActivity object) {
        object.getRefinements().remove((Activity) this.elementToRemove);
        setReferenceNull((Activity) this.elementToRemove);

        return object;
    }

    @Override
    public Object defaultCase(EObject object) {
        if (object instanceof CompositeTask) {
            if (((CompositeTask) object).getSubtasks().contains(this.elementToRemove)) {
                logger.debug("Found element in CompositeTask");
                ((CompositeTask) object).getSubtasks().remove(this.elementToRemove);
            }
        }
        return object;
    }

    private void setReferenceNull(Activity activity) {
        activity.getSelectioncontainer().setSelected(false);
        activity.getSelectioncontainer().setActivity(null);
        activity.setSelectioncontainer(null);
    }

    public void setActivitytoremove(Object activityToRemove) {
        this.elementToRemove = activityToRemove;
    }
}
