package de.fzi.kamp.service.workplanmanagement;

import org.apache.log4j.Logger;

import de.fzi.maintainabilitymodel.activity.implementation.ImplementComponentActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementComponentActivityRefinement;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementDataTypeActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementOperationActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementProvidedInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementProvidedInterfaceportActivityRefinement;
import de.fzi.maintainabilitymodel.activity.implementation.util.ImplementationSwitch;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;

public class ImplementationInsertingSwitch extends ImplementationSwitch<Activity> {
    private final static Logger logger = Logger.getLogger(ImplementationInsertingSwitch.class);

    Activity activityToInsert = null;

    @Override
    public Activity caseImplementComponentActivity(ImplementComponentActivity implementComponentActivity) {

        implementComponentActivity.getRefinements().add((ImplementComponentActivityRefinement) this.activityToInsert);

        return implementComponentActivity;
    }

    @Override
    public Activity caseImplementDataTypeActivity(ImplementDataTypeActivity implementDataTypeActivity) {

        // What to do here? No refinements or follow-up list.

        return implementDataTypeActivity;
    }

    @Override
    public Activity caseImplementProvidedInterfaceportActivity(
            ImplementProvidedInterfaceportActivity implementProvidedInterfaceportActivity) {

        if (implementProvidedInterfaceportActivity == this.activityToInsert) {
            // getting the selection container of the interface definition from which the interface
            // port is inherited
            InterfaceSelectionContainer interfaceSelectionContainer = ((InterfacePortSelectionContainer) implementProvidedInterfaceportActivity
                    .getSelectioncontainer()).getInterfaceSelectionContainer();
            if (interfaceSelectionContainer.getActivity() != null) {
                doSwitch(interfaceSelectionContainer.getActivity());
            }
        } else {
            implementProvidedInterfaceportActivity.getRefinements().add(
                    (ImplementProvidedInterfaceportActivityRefinement) this.activityToInsert);
        }
        return implementProvidedInterfaceportActivity;
    }

    @Override
    public Activity caseImplementOperationActivity(ImplementOperationActivity implementOperationActivity) {
        // Nothing to insert
        return implementOperationActivity;
    }

    public void setActivityToInsert(Activity activityToInsert) {
        this.activityToInsert = activityToInsert;
    }
}
