package de.fzi.kamp.service.workplanmanagement;

import org.apache.log4j.Logger;

import de.fzi.kamp.derivation.IArchitectureModelResolver;
import de.fzi.kamp.derivation.IContainerFactory;
import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.SelectioncontainerFactoryImpl;

public class ContainerFactory implements IContainerFactory {
    private final static Logger logger = Logger.getLogger(ContainerFactory.class);

    @Override
    public CompositeTaskDerivationContainer createContainer(IArchitectureModelResolver architectureModelProvider,
            EffortAnalysisInstance analysisInstance, CompositeTask rootTaskInWorkplan) {

        CompositeTaskDerivationContainer compositeTaskContainer = SelectioncontainerFactoryImpl.eINSTANCE
                .createCompositeTaskDerivationContainer();

        new CompositeTaskDerivationContainerBuilder((IArchitectureModelProvider) architectureModelProvider)
                .buildProxyAndContainerStructureForMilestone(compositeTaskContainer, analysisInstance);
        compositeTaskContainer.setActivity(rootTaskInWorkplan);
        rootTaskInWorkplan.setSelectioncontainer(compositeTaskContainer);
        analysisInstance.getWorkplan().getCompositetaskderivationcontainer().add(compositeTaskContainer);

        return compositeTaskContainer;
    }
}
