package de.fzi.kamp.service.workplanmanagement;

import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;

import de.fzi.kamp.derivation.CorrespondingContainerFinderForSAMM;
import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.architecturemodel.impl.TransportInterfaceInformationContainer;
import de.fzi.kamp.service.architecturemodel.impl.switches.ComponentContainerCreationSwitch;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractDatatype;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractInterfacePort;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractModelElement;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractOperationImplementation;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMInterfaceProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMOperationDefinitionProxy;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationDefinitionSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationImplementationSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.SelectioncontainerFactory;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.SelectioncontainerFactoryImpl;
import eu.qimpress.samm.staticstructure.Operation;

public class CompositeTaskDerivationContainerBuilder {
    private final static Logger logger = Logger.getLogger(CompositeTaskDerivationContainerBuilder.class);

    private CompositeTaskDerivationContainer workplanContainer;
    private WorkplanDerivationManager workplanManager;
    private EffortAnalysisInstance analysisInstance;
    private IArchitectureModelProvider architectureModelProvider;

    public CompositeTaskDerivationContainerBuilder(IArchitectureModelProvider architectureModelProvider) {
        this.architectureModelProvider = architectureModelProvider;
    }

    public void buildProxyAndContainerStructureForMilestone(CompositeTaskDerivationContainer workplanContainer,
            EffortAnalysisInstance instance) {

        this.workplanContainer = workplanContainer;
        this.workplanManager = new WorkplanDerivationManager(workplanContainer);
        this.analysisInstance = instance;

        this.fillComponentList();
        this.fillInterfaceList();
        this.fillDataTypeList();
    }

    private void fillComponentList() {
    	List<AbstractModelElement> componentProxyList = this.architectureModelProvider.getComponents(analysisInstance
                .getTargetArchitecturalAlternative().getArchitecturemodel());
        CorrespondingContainerFinderForSAMM containerFinder = new CorrespondingContainerFinderForSAMM(this.workplanContainer);
    	ComponentContainerCreationSwitch componentContainerCreattionSwitch = 
    				new ComponentContainerCreationSwitch(this.workplanContainer);
        
    	for(AbstractModelElement component : componentProxyList){
    		AbstractContainer container = containerFinder.doSwitch(component);
    		if(container == null){
    			container = componentContainerCreattionSwitch.doSwitch(component);    			
    		}
    		//TODO The creation of the components has to be performed!!!
    		//But it is necessary to have the meta model changes to do it properly!! 
    		
    		
    		//TODO: Creation of interface ports has to be activated
//    		this.setupInterfacePortContainersForComponent(container);
    	}
    	setSubcomponentRelation();
       
    }
    
    private void setSubcomponentRelation() {
		for(CompositeComponentSelectionContainer compositeComponentSelectionContainer : this.workplanContainer.getCompositeComponentSelectionContainer()){
			this.architectureModelProvider.assignComponentNestingToContainerStructure(compositeComponentSelectionContainer, this.workplanContainer);
			
		}
		
	}

    private void fillInterfaceList() {

        for (TransportInterfaceInformationContainer ifaceTransportationContainer : this.architectureModelProvider
                .getInterfaces(analysisInstance.getTargetArchitecturalAlternative().getArchitecturemodel())) {
            InterfaceSelectionContainer interfaceSelectionContainer = SelectioncontainerFactoryImpl.eINSTANCE
                    .createInterfaceSelectionContainer();

            if (ifaceTransportationContainer.getIface() != null) {
                interfaceSelectionContainer.setReferencedInterface(ifaceTransportationContainer.getIface());
            } else {
                logger.debug("Interface is null!");
            }
            
            //Creating and attaching all operation definition container
            for(Operation operationDefintion : ((SAMMInterfaceProxy)interfaceSelectionContainer.getReferencedInterface()).getInterface().getSignatures()){
            	AbstractModelElement elementProxy = this.architectureModelProvider.getSAMMProxyElement(operationDefintion);
            	if(elementProxy instanceof  SAMMOperationDefinitionProxy){
            		SAMMOperationDefinitionProxy sammOperationDefinitionProxy = (SAMMOperationDefinitionProxy)elementProxy;
            		OperationDefinitionSelectionContainer operationDefSelectionContainer = 
            			SelectioncontainerFactory.eINSTANCE.createOperationDefinitionSelectionContainer();
            		
            		operationDefSelectionContainer.setAbstractOperation(sammOperationDefinitionProxy);
            		operationDefSelectionContainer.setInterfaceselectioncontainer(interfaceSelectionContainer);
            		interfaceSelectionContainer.getOperationDefinitionSelectionContainer().add(operationDefSelectionContainer);
            	}            	
            }
           
            interfaceSelectionContainer.setBasicActivity(null);
            this.workplanContainer.getTopLevelActivityContainer().add(interfaceSelectionContainer);
            this.workplanContainer.getInterfaceSelectionContainers().add(interfaceSelectionContainer);
            this.analysisInstance.getWorkplan().getModelElementToContainerMap().put(ifaceTransportationContainer.getIface(), interfaceSelectionContainer);
        }
    }

    private void fillDataTypeList() {

        List<AbstractDatatype> alreadyAdded = new LinkedList<AbstractDatatype>();

        for (AbstractDatatype type : this.architectureModelProvider.getDatatypes(analysisInstance.getTargetArchitecturalAlternative()
                .getArchitecturemodel())) {
            if (!alreadyAdded.contains(type)) {
                alreadyAdded.add(type);

                DataTypeSelectionContainer container = SelectioncontainerFactoryImpl.eINSTANCE
                        .createDataTypeSelectionContainer();
                container.setType(type);
                container.setBasicActivity(null);

                for (InterfaceSelectionContainer interfaceContainer : this.workplanContainer
                        .getInterfaceSelectionContainers()) {
                    List<AbstractDatatype> datatypes = this.architectureModelProvider
                            .getDataTypesOfInterface(interfaceContainer.getReferencedInterface());
                    if (datatypes.contains(type))
                        container.getCompleteInterfaceSelectionContainers().add(interfaceContainer);
                }

                container.setBasicActivity(null);
                this.workplanContainer.getDataTypeSelectionContainers().add(container);
                this.workplanContainer.getTopLevelActivityContainer().add(container);
                this.analysisInstance.getWorkplan().getModelElementToContainerMap().put(type, container);
            }
        }
    }

    private void setupInterfacePortContainersForComponent(ComponentSelectionContainer component) {

        for (AbstractInterfacePort interfacePort : this.architectureModelProvider.getProvidedInterfacePorts(
        		component.getComponenttype())) {
            InterfacePortSelectionContainer providedInterfacePortContainer = SelectioncontainerFactoryImpl.eINSTANCE
                    .createInterfacePortSelectionContainer();
            providedInterfacePortContainer.setInterfaceport(interfacePort);
            providedInterfacePortContainer.setBasicActivity(null);
            component.getRefinements().add(providedInterfacePortContainer);
            setupOperationImplementationsForInterfacePortContainers(providedInterfacePortContainer);
            this.analysisInstance.getWorkplan().getModelElementToContainerMap().put(interfacePort, providedInterfacePortContainer);
        }

        for (AbstractInterfacePort interfacePort : this.architectureModelProvider.getRequiredInterfacePorts(
        		component.getComponenttype())) {
            InterfacePortSelectionContainer requiredInterfacePortContainer = SelectioncontainerFactoryImpl.eINSTANCE
                    .createInterfacePortSelectionContainer();
            requiredInterfacePortContainer.setInterfaceport(interfacePort);
            requiredInterfacePortContainer.setBasicActivity(null);
            component.getRefinements().add(requiredInterfacePortContainer);
            setupOperationImplementationsForInterfacePortContainers(requiredInterfacePortContainer);
            this.analysisInstance.getWorkplan().getModelElementToContainerMap().put((interfacePort), requiredInterfacePortContainer);
        }
    }
   
    private void setupOperationImplementationsForInterfacePortContainers(InterfacePortSelectionContainer interfacePortContainer) {

        AbstractInterfacePort interfacePort = interfacePortContainer.getInterfaceport();

        for (AbstractOperationImplementation operation : this.architectureModelProvider.getOperationImplementations(interfacePort)) {
            OperationImplementationSelectionContainer container = SelectioncontainerFactoryImpl.eINSTANCE
                    .createOperationImplementationSelectionContainer();
            container.setOperation(operation);
            container.setBasicActivity(null);
            interfacePortContainer.getRefinements().add(container);
            this.analysisInstance.getWorkplan().getModelElementToContainerMap().put(operation, container);
        }
    }
}