package de.fzi.kamp.service.workplanmanagement;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.activity.adaptation.ChangeComponentImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeDataTypeActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceDefinitionActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeOperationImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.util.AdaptationSwitch;
import de.fzi.maintainabilitymodel.workplan.Activity;

public class AdaptationRemovalSwitch extends AdaptationSwitch<Object> {
    private final static Logger logger = Logger.getLogger(AdaptationRemovalSwitch.class);

    private Object activityToRemove = null;

    @Override
    public Object caseChangeComponentImplementationActivity(ChangeComponentImplementationActivity object) {

        object.getRefinements().remove(this.activityToRemove);
        setReferenceNull((Activity) this.activityToRemove);
        return object;
    }

    @Override
    public Object caseChangeDataTypeActivity(ChangeDataTypeActivity object) {

        object.getFollowups().remove((Activity) this.activityToRemove);
        setReferenceNull((Activity) this.activityToRemove);

        return object;
    }

    @Override
    public Object caseChangeOperationImplementationActivity(ChangeOperationImplementationActivity object) {
        setReferenceNull(object);
        return object;
    }

    @Override
    public Object caseChangeInterfaceportActivity(ChangeInterfaceportActivity object) {
        object.getRefinements().remove((Activity) this.activityToRemove);
        setReferenceNull((Activity) this.activityToRemove);

        return object;
    }

    @Override
    public Object caseChangeInterfaceDefinitionActivity(ChangeInterfaceDefinitionActivity object) {
        object.getRefinements().remove((Activity) this.activityToRemove);
        setReferenceNull((Activity) this.activityToRemove);

        return object;
    }

    @Override
    public Object defaultCase(EObject object) {
        ImplementationRemovalSwitch implementationRemovalSwitch = new ImplementationRemovalSwitch();
        implementationRemovalSwitch.setActivitytoremove(this.activityToRemove);
        implementationRemovalSwitch.doSwitch(object);

        return object;
    }

    private void setReferenceNull(Activity activity) {
        activity.getSelectioncontainer().setSelected(false);
        activity.getSelectioncontainer().setActivity(null);
        activity.setSelectioncontainer(null);
    }

    public void setActivitytoremove(Object activityToRemove) {
        this.activityToRemove = activityToRemove;
    }
}
