package de.fzi.kamp.service.workplanmanagement;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.activity.adaptation.ChangeComponentImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeComponentImplementationActivityRefinement;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeDataTypeActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceDefinitionActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceDefinitionActivityFollowup;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceportActivityRefinement;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeOperationImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.RemoveInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.RemoveInterfaceportActivityRefinement;
import de.fzi.maintainabilitymodel.activity.adaptation.util.AdaptationSwitch;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;

public class AdaptationInsertingSwitch extends AdaptationSwitch<Object> {
    private final static Logger logger = Logger.getLogger(AdaptationInsertingSwitch.class);

    Activity activityToInsert = null;

    @Override
    public Object caseChangeComponentImplementationActivity(
            ChangeComponentImplementationActivity changeComponentImplementationActivity) {

        changeComponentImplementationActivity.getRefinements().add(
                (ChangeComponentImplementationActivityRefinement) this.activityToInsert);

        return changeComponentImplementationActivity;
    }

    @Override
    public Object caseChangeDataTypeActivity(ChangeDataTypeActivity changeDataTypeActivity) {

        changeDataTypeActivity.getFollowups().add((ChangeInterfaceDefinitionActivity) this.activityToInsert);

        return changeDataTypeActivity;
    }

    @Override
    public Object caseChangeInterfaceDefinitionActivity(
            ChangeInterfaceDefinitionActivity changeInterfaceDefinitionActivity) {

        changeInterfaceDefinitionActivity.getFollowups().add(
                (ChangeInterfaceDefinitionActivityFollowup) this.activityToInsert);

        return changeInterfaceDefinitionActivity;
    }

    @Override
    public Object caseChangeInterfaceportActivity(ChangeInterfaceportActivity changeInterfaceportActivity) {

        if (changeInterfaceportActivity == this.activityToInsert) {
            // getting the selection container of the interface definition from which the interface
            // port is inherited
            InterfaceSelectionContainer interfaceSelectionContainer = ((InterfacePortSelectionContainer) changeInterfaceportActivity
                    .getSelectioncontainer()).getInterfaceSelectionContainer();
            if (interfaceSelectionContainer.getActivity() != null) {
                doSwitch(interfaceSelectionContainer.getActivity());
            }
        } else {

            changeInterfaceportActivity.getRefinements().add(
                    (ChangeInterfaceportActivityRefinement) this.activityToInsert);
        }

        return changeInterfaceportActivity;
    }

    @Override
    public Object caseChangeOperationImplementationActivity(
            ChangeOperationImplementationActivity changeOperationImplementationActivity) {
        // Nothing has to be inserted.
        return changeOperationImplementationActivity;
    }

    @Override
    public Object defaultCase(EObject object) {
        ImplementationInsertingSwitch implementationInsertingSwitch = new ImplementationInsertingSwitch();
        implementationInsertingSwitch.setActivityToInsert(this.activityToInsert);
        implementationInsertingSwitch.doSwitch(object);

        return object;
    }

    @Override
    public Object caseRemoveInterfaceportActivity(RemoveInterfaceportActivity removeInterfaceportActivity) {
        removeInterfaceportActivity.getRefinements().add((RemoveInterfaceportActivityRefinement) this.activityToInsert);
        return removeInterfaceportActivity;
    }

    public void setActivityToInsert(Activity activityToInsert) {
        this.activityToInsert = activityToInsert;
    }
}
