package de.fzi.kamp.service.workplanmanagement;

import org.apache.log4j.Logger;

import de.fzi.maintainabilitymodel.activity.adaptation.AdaptationFactory;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeDataTypeActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceDefinitionActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementationFactory;
import de.fzi.maintainabilitymodel.activity.repository.ComponentActivity;
import de.fzi.maintainabilitymodel.activity.repository.InterfacePortActivity;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationImplementationSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.util.SelectioncontainerSwitch;

public class ActivityCreationSwitch extends SelectioncontainerSwitch<Activity> {
    private final static Logger logger = Logger.getLogger(ActivityCreationSwitch.class);
    
    private CompositeTask compositeTask;
    private AdaptationInsertingSwitch adaptationInsertingSwitch = new AdaptationInsertingSwitch();    

    @Override
    public Activity caseComponentSelectionContainer(ComponentSelectionContainer componentSelectionContainer) {
        ComponentActivity componentActivity = null;
	    if(componentSelectionContainer.getActivity() == null){
	        switch (componentSelectionContainer.getBasicActivity()) {
	        case ADD:
	            componentActivity = ImplementationFactory.eINSTANCE.createImplementComponentActivity();
	            break;
	        case CHANGE:
	            componentActivity = AdaptationFactory.eINSTANCE.createChangeComponentImplementationActivity();
	            break;
	        case REMOVE:
	            componentActivity = AdaptationFactory.eINSTANCE.createRemoveComponentActivity();
	            break;
	        }
	                 
	        componentActivity.setSelectioncontainer(componentSelectionContainer);
	        componentActivity.setComponent(componentSelectionContainer.getComponenttype());
	        componentSelectionContainer.setActivity(componentActivity);
	        componentSelectionContainer.setSelected(true);
	        
	        if(this.compositeTask == null){
	        	setCompositeTask((AbstractContainer)componentSelectionContainer.eContainer());        	
	        }
	        this.compositeTask.getSubtasks().add(componentActivity);
	        
	        if(!componentSelectionContainer.getRefinements().isEmpty()){
	        	for(InterfacePortSelectionContainer interfacePortContainer: componentSelectionContainer.getRefinements()){
	        		if(interfacePortContainer.isSelected()){
	        			Activity activity = doSwitch(interfacePortContainer);
		        		if(activity != null){
		        			insertActivityIntoWorkplan(activity);
		        		}
	        		}
	        	}
	        }
	    }else{
	    	componentActivity = (ComponentActivity) componentSelectionContainer.getActivity();
	    }
        return componentActivity;
    }

   	@Override
    public Activity caseDataTypeSelectionContainer(DataTypeSelectionContainer datatypeSelectionContainer) {
   		ChangeDataTypeActivity datatypeActivity = null;
   		if(datatypeSelectionContainer.getActivity() == null){
	        datatypeActivity = AdaptationFactory.eINSTANCE.createChangeDataTypeActivity();
	
	        datatypeActivity.setDatatype(datatypeSelectionContainer.getType());
	        datatypeActivity.setSelectioncontainer(datatypeSelectionContainer);
	        datatypeSelectionContainer.setActivity(datatypeActivity);
	        datatypeSelectionContainer.setSelected(true);
	        
	        if(this.compositeTask == null){
	        	setCompositeTask((AbstractContainer)datatypeSelectionContainer.eContainer());        	
	        }
	        this.compositeTask.getSubtasks().add(datatypeActivity);
	        
	        if(!datatypeSelectionContainer.getCompleteInterfaceSelectionContainers().isEmpty()) {
	        	for(InterfaceSelectionContainer interfaceContainer : datatypeSelectionContainer.getCompleteInterfaceSelectionContainers()){
	        		interfaceContainer.setSelected(true);
	        		setBasicActivity(interfaceContainer, datatypeSelectionContainer.getBasicActivity());
	        		Activity activity = doSwitch(interfaceContainer); 
	        		if (activity != null){
	        			insertActivityIntoWorkplan(activity);
	        		}
	        	}
	        }
	        
   		}else{
   			datatypeActivity = (ChangeDataTypeActivity) datatypeSelectionContainer.getActivity();
   		}

        return datatypeActivity;
    }

    @Override
    public Activity caseInterfacePortSelectionContainer(InterfacePortSelectionContainer interfacePortContainer) {

        InterfacePortActivity interfacePortActivity = null;
        
        if(interfacePortContainer.getActivity() == null){

	        switch (interfacePortContainer.getBasicActivity()) {
	        case ADD:
	            interfacePortActivity = ImplementationFactory.eINSTANCE.createImplementProvidedInterfaceportActivity();
	            break;
	        case CHANGE:
	            interfacePortActivity = AdaptationFactory.eINSTANCE.createChangeInterfaceportActivity();
	            break;
	        case REMOVE:
	            interfacePortActivity = AdaptationFactory.eINSTANCE.createRemoveInterfaceportActivity();
	            break;
	        }
	        interfacePortActivity.setInterfaceport(interfacePortContainer.getInterfaceport());
	        interfacePortActivity.setSelectioncontainer(interfacePortContainer);
	        interfacePortContainer.setActivity(interfacePortActivity);
	        interfacePortContainer.setSelected(true);
	
	        if (interfacePortContainer.isSignaturechange()) {
	            interfacePortActivity.setSignaturechange(true);
	        }
	        
	        if(!interfacePortContainer.getRefinements().isEmpty()){
	        	for(OperationImplementationSelectionContainer operationContainer : interfacePortContainer.getRefinements()){
		        	if(operationContainer.isSelected()){	
	        			Activity activity = doSwitch(operationContainer);
		        		if(activity != null){
		        			insertActivityIntoWorkplan(activity);
		        		}
		        	}
	        	}
	        }
	        
        }else{
        	interfacePortActivity = (InterfacePortActivity) interfacePortContainer.getActivity();
        }

        return interfacePortActivity;
    }

    @Override
    public Activity caseInterfaceSelectionContainer(InterfaceSelectionContainer interfaceSelectionContainer) {

        ChangeInterfaceDefinitionActivity changeInterfaceDefinitionActivity = null;
        if(interfaceSelectionContainer.getActivity() == null){
        
	        changeInterfaceDefinitionActivity = AdaptationFactory.eINSTANCE.createChangeInterfaceDefinitionActivity();
	
	        changeInterfaceDefinitionActivity.setAinterface(interfaceSelectionContainer.getReferencedInterface());
	        changeInterfaceDefinitionActivity.setSelectioncontainer(interfaceSelectionContainer);
	        interfaceSelectionContainer.setActivity(changeInterfaceDefinitionActivity);
	        interfaceSelectionContainer.setSelected(true);
	
	        if(this.compositeTask == null){
	        	setCompositeTask((AbstractContainer)interfaceSelectionContainer.eContainer());        	
	        }
	        this.compositeTask.getSubtasks().add(changeInterfaceDefinitionActivity);
	        
	        if(interfaceSelectionContainer.getFollowups().size() > 0){
	        	for(InterfacePortSelectionContainer interfacePortContainer : interfaceSelectionContainer.getFollowups()){
	        		interfacePortContainer.setSelected(true);
	        		interfacePortContainer.setSignaturechange(true);
	        		setBasicActivity(interfacePortContainer, interfaceSelectionContainer.getBasicActivity());
	        		Activity activity = doSwitch(interfacePortContainer);
	        		if(activity != null){
	        			insertActivityIntoWorkplan(activity);
	        		}
	        	}
	        }
        }else{
        	changeInterfaceDefinitionActivity = (ChangeInterfaceDefinitionActivity) interfaceSelectionContainer.getActivity();
        }
        
        return changeInterfaceDefinitionActivity;
    }

//	@Override
//    public Activity caseOperationSelectionContainer(OperationDefinitionSelectionContainer operationContainer) {
//    	
//    	OperationActivity operationActivity = null;
//    	
//    	if(operationContainer.getActivity() == null){
//
//	        switch (operationContainer.getBasicActivity()) {
//	        case ADD:
//	            operationActivity = ImplementationFactory.eINSTANCE.createImplementOperationActivity();
//	            break;
//	        case CHANGE:
//	            operationActivity = AdaptationFactory.eINSTANCE.createChangeOperationImplementationActivity();
//	            break;
//	        case REMOVE:
//	            operationActivity = AdaptationFactory.eINSTANCE.createRemoveOperationImplementationActivity();
//	            break;
//	        }
//	
//	        if (operationContainer.isSignaturechange()) {
//	            operationActivity.setSignaturechange(true);
//	        }
//	
//	        operationActivity.setSelectioncontainer(operationContainer);
//	        operationActivity.setOperation(operationContainer.getOperation());
//	        operationContainer.setActivity((Activity) operationActivity);
//	        operationContainer.setSelected(true);
//    	}else{
//    		operationActivity = (OperationActivity) operationContainer.getActivity();
//    	}
//
//        return operationActivity;
//    }

    private void setBasicActivity(AbstractContainer container, BasicActivity basicActivity){
    	switch(basicActivity){
    	case ADD : container.setBasicActivity(BasicActivity.ADD);
    		break;
    	case CHANGE : container.setBasicActivity(BasicActivity.CHANGE);
    		break;
    	case REMOVE : container.setBasicActivity(BasicActivity.REMOVE);
    		break;	
    	}
    }
    
    private void setCompositeTask(AbstractContainer compositeTaskContainer) {
    	if(compositeTaskContainer instanceof CompositeTaskDerivationContainer){
    		this.compositeTask = (CompositeTask) compositeTaskContainer.getActivity();
    	}
	}
    
    private void testWhetherEContainerExists(Activity activityToInsert){
    	AbstractContainer container = (AbstractContainer) activityToInsert.getSelectioncontainer().eContainer();
        
        if (container.getActivity() == null) {
            container.setBasicActivity(BasicActivity.CHANGE);
            doSwitch(container);
        }
    }
    
    private void insertActivityIntoWorkplan(Activity activity) {
		this.adaptationInsertingSwitch.setActivityToInsert(activity);
		testWhetherEContainerExists(activity);
		this.adaptationInsertingSwitch.doSwitch(((AbstractContainer)activity.getSelectioncontainer().eContainer()).getActivity());
	}
}
