package de.fzi.kamp.service.preparation;

import java.util.List;

import org.eclipse.swt.widgets.Display;

import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;

public interface IPreparationManager {

    List<ArchitecturalAlternative> loadAndSelectArchitectureModels();

    List<ArchitecturalAlternative> getArchitectureAlternatives();

    void removeArchitectureAlternative(ArchitecturalAlternative architectureAlternative);

    void editArchitectureAlternative(ArchitecturalAlternative architectureAlternative);

    void checkComplexityAnnotationsForArchitectureAlternative(ArchitecturalAlternative architectureAlternative);

    void addChangeRequest();

    // ChangeRequest createChangeRequest(String name, String description);
    List<ChangeRequest> getChangeRequests();

    void removeChangeRequest(ChangeRequest changeRequest);

    void editChangeRequest(ChangeRequest changeRequest);

    void openMapElementsToDevelopersDialog(WorkOrganisationModel workorganisation,
            AbstractArchitectureModel architectureModel, Display display, IMainEditor editor);

    MaintainabilityAnalysisModel getAnalysisModel();

    IArchitectureModelProvider getArchitectureModelProvider();
}
