package de.fzi.kamp.service.maineditor;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.swt.widgets.Shell;

import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.Workplan;

public interface IMainEditor extends ICommandHandler {

    /**
     * Shows workplan changes (content and view).
     * 
     * @param workplan
     *            The workplan to be displayed.
     * @param isEditableEffort
     *            IS the editable-effort view active?
     */
    public void showWorkplanChanges(Workplan workplan, boolean isEditableEffort);

    /**
     * @return Returns the adapter factory for this editor.
     */
    public ComposedAdapterFactory getAdapterFactory();

    /**
     * @return Returns the adapter factory editing domain for this editor.
     */
    public AdapterFactoryEditingDomain getEditingDomain();

    /**
     * @return Returns the central page of this editor having a stack layout holding all pages.
     */
    public ICentralEditorPage getCentralPage();

    /**
     * @return Returns the architecture model provider.
     */
    public IArchitectureModelProvider getArchitectureModelProvider();

    /**
     * @return Returns the shell used by the main editor (for example for dialogs).
     */
    public Shell getMainEditorShell();

    /**
     * @return Returns the project in which the current kamp-file is located.
     */
    public IProject getParentprojectOfKampFile();

    /**
	 * 
	 */
    void notifyAnalysisInstanceAdapter(EffortAnalysisInstance instance);
    
    public AnalysisManager getAnalysisManager();
}
