package de.fzi.kamp.service.maineditor;

import de.fzi.maintainabilitymodel.workplan.Workplan;

/**
 * Interface for the central editor page containing the different layers for preparation page,
 * analysis instances page, workorganisation page and the workplan page.
 * 
 * @author tknapp
 * 
 */
public interface ICentralEditorPage {

    /**
     * Sets the buttons to modify the workplan visible.
     */
    void setAddCompositeActivityButtonVisible();

    /**
     * Sets the buttons to modify the workplan invisible.
     */
    void setAddCompositeActivityButtonInvisible();

    /**
     * Sets the analysis page as the top element in the stack layout of the central editor.
     */
    void setAnalysisPageAsTopControl();

    /**
     * Sets the architecture alternative page as the top element in the stack layout of the central editor.
     */
    void setArchitectureAlternativePageAsTopControl();

    /**
     * Sets the change scenario page as the top element in the stack layout of the central editor.
     */
    void setChangeScenarioPageAsTopControl();

    /**
     * This method starts a routine to show the developer structure in the workplan.
     * 
     * @param showDeveloperStructure
     */
    void showDeveloperStructure(boolean showDeveloperStructure);

    /**
     * Sets the workorganisation page as the top element in the stack layout of the central editor.
     */
    void setWorkorganisationPageAsTopControl();

    /**
     * Updates the workplan tree after content or view changes.
     * 
     * @param workplan
     *            The workplan to be displayed.
     * @param followUp
     *            Should the follow-up view become active?
     * @param isEditableEffort
     *            Should the editable-effort view become active?
     * @param isLowestAbstraction
     *            Should the lowest-abstraction view become active?
     */
    void updateWorkplanTree(Workplan workplan, boolean followUp, boolean isEditableEffort, boolean isLowestAbstraction);
    
    /**
     * Returns whether on the workplan table the effort estimation view is activated.
     */
    boolean effortEstimationViewIsActivated();

}
