package de.fzi.kamp.service.general;

import java.util.List;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;

/**
 * Manager to handle the wizards used for the workplan building process.
 * 
 * @author tknapp
 * 
 */
public interface IWizardManager {

    /**
     * Shows the wizard to add a new compsite activity describing the activities for a special
     * changing reason.
     * 
     * @param instance
     *            The {@code EffortAnalysisInstance} which is the basis for the change.
     * @param shell
     *            Shell associated with the editor.
     * @param editor
     *            The editor showing the tool.
     * @param architectureModelProvider
     *            A provider for the underlying architecture model.
     * @return A list of the selected abstract containers.
     */
    List<? extends AbstractContainer> showAddCompositeActivityWizard(EffortAnalysisInstance instance, Shell shell,
            IMainEditor editor, IArchitectureModelProvider architectureModelProvider);

    void showFurtherWorkplanDerivationWizard(Tree tree, IMainEditor mainEditor);

    void showCalculateFollowUpsWizard(Tree workplanTree, IMainEditor mainEditor);
    
    void showErrorMessage(String message, Shell shell);
}
