package de.fzi.kamp.service.general;

import java.util.List;

import org.eclipse.swt.widgets.Display;

import de.fzi.kamp.service.analysisinstance.AlternativeAndChangeRequestTuple;
import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.kamp.service.preparation.IPreparationManager;
import de.fzi.kamp.service.preparation.impl.PreparationManager;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;

/**
 * Interface for an dialog manager.
 * 
 * @author tknapp
 * 
 */
public interface IDialogManager {

    /**
     * Method should open the dialog for selecting the underlying architecture model.
     * 
     * @param abstractArchitectureModelList
     *            A list containing the architecture models which can be chosen (at the moment just
     *            SAMMs can be chosen, but in future it is planned to also to get a connection to
     *            Palladio Component Models).
     * @param selectedModels
     *            A list of the already selected models.
     * @param alternative
     *            An architecture alternative.
     * @return A list of the selected models.
     */
    List<AbstractArchitectureModel> showSelectArchitectureModelDialog(MaintainabilityAnalysisModel analysisModel,
            List<AbstractArchitectureModel> architectureModelList, List<AbstractArchitectureModel> selectedModels,
            ArchitecturalAlternative alternative, PreparationManager preparationManager);

    /**
     * Method should show a dialog to change the properties of a selected architecture alternative.
     * 
     * @param architectureAlternative
     */
    void showEditArchitectureAlternativeDialog(ArchitecturalAlternative architectureAlternative,
            IPreparationManager preparationManager);

    /**
     * Should show a wizard to check the complexity annotations. TODO: Implement!
     */
    void showCheckComplexityAnnotationsWizard();

    /**
     * Method should open a dialog to add a new change request.
     * 
     * @param changeRequest
     *            An empty change request to be filled in the dialog.
     * @return A boolean whether the user confirmed the dialog with <i>OK</i> or not. It indicates
     *         whether to add the change request to the analysis model or not.
     */
    boolean showNewChangeRequestDialog(ChangeRequest changeRequest);

    /**
     * Shows a dialog to change the properties of a change request.
     * 
     * @param changeRequest
     *            The change request to be changed
     */
    boolean showEditChangeRequestDialog(ChangeRequest changeRequest);

    /**
     * Shows a dialog to select an architecture alternative and a change request which will
     * establish a new analysis instance. Both elements will be given back in an tuple.
     * 
     * @param analysisModel
     * @return
     */
    AlternativeAndChangeRequestTuple showSelectArchitectureAlternativeAndChangeRequestDialog(
            MaintainabilityAnalysisModel analysisModel);

    void openMapElementsToDevelopersDialog(WorkOrganisationModel workorganisation,
            AbstractArchitectureModel architectureModel, Display display, ICommandHandler commandHandler);

    void showSelectAffectedFollowUpComponent();
}
