package de.fzi.kamp.service.general;

import org.apache.log4j.Logger;

import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.kamp.service.analysisinstance.impl.AnalysisInstanceManager;
import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.preparation.IPreparationManager;
import de.fzi.kamp.service.preparation.impl.PreparationManager;
import de.fzi.maintainabilitymodel.main.MainFactory;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;

/**
 * Manager to handle operations concerning the analysis process. This class also provides getters
 * for the {@link PreparationManager}, the {@link AnalysisInstanceManager} and the
 * {@link AnalysisModel}.
 * 
 * @author tknapp
 * 
 */
public class AnalysisManager {
    private final static Logger logger = Logger.getLogger(AnalysisManager.class);

    private IDialogManager dialogManager;
    private IPreparationManager preparationManager;
    private IAnalysisInstanceManager analysisInstanceManager;
    private IWizardManager wizardManager;
    private IMainEditor mainEditor;

    private MaintainabilityAnalysisModel analysisModel;

    /**
     * @param analysisModel
     *            The underlying analysis model.
     * @param provider
     *            An {@link IArchitectureModelProvider}.
     * @param dialogManager
     *            Manager to handle dialogs.
     * @param wizardManager
     *            Manager to handle the wizards.
     * @param commandHandler
     *            Manager to handle commands.
     */
    public AnalysisManager(MaintainabilityAnalysisModel analysisModel, IArchitectureModelProvider provider,
            IDialogManager dialogManager, IWizardManager wizardManager, IMainEditor mainEditor) {

        this.analysisModel = analysisModel;
        this.dialogManager = dialogManager;
        this.wizardManager = wizardManager;
        this.mainEditor = mainEditor;
        this.preparationManager = new PreparationManager(this.analysisModel, provider, this.dialogManager,
                this.mainEditor);
        this.analysisInstanceManager = new AnalysisInstanceManager(this.analysisModel, this.dialogManager,
                this.wizardManager, this.mainEditor);
    }

    public IPreparationManager getPreparationManager() {
        return preparationManager;
    }

    public IAnalysisInstanceManager getAnalysisInstanceManager() {
        return analysisInstanceManager;
    }

    /**
     * Creates a new {@link MaintainabilityAnalysisModel}.
     */
    private void createNewAnalysisModel() {
        // TODO: replace by "new model" wizard
        this.analysisModel = MainFactory.eINSTANCE.createMaintainabilityAnalysisModel();
    }

    public MaintainabilityAnalysisModel getAnalysisModel() {
        return analysisModel;
    }

    public void setAnalysisModel(MaintainabilityAnalysisModel analysisModel) {
        this.analysisModel = analysisModel;
    }
}
