package de.fzi.kamp.service.commands;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;

import de.fzi.kamp.service.preparation.impl.PreparationManager;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;

/**
 * Command to remove a change request. It is realized as a command, because this operation causes a
 * change in the analysis model, which should be saved.
 * 
 * @author tknapp
 * 
 */
public class RemoveChangeRequestCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(RemoveChangeRequestCommand.class);

    private PreparationManager preparationManager;
    private ChangeRequest changeRequest;

    /**
     * @param preparationManager
     *            Manager to handle all actions occurring on the preparation page.
     * @param changeRequest
     *            The change request to remove.
     */
    public RemoveChangeRequestCommand(PreparationManager preparationManager, ChangeRequest changeRequest) {
        this.preparationManager = preparationManager;
        this.changeRequest = changeRequest;
    }

    /**
     * Removes the change request from analysis model.
     */
    @Override
    public void execute() {
        this.preparationManager.getAnalysisModel().getChangerequests().remove(changeRequest);
    }

    /**
     * Not implemented.
     */
    @Override
    public void redo() {
        // TODO Auto-generated method stub

    }

    /**
     * Tests whether all parameters are unequal to {@code null}.
     */
    @Override
    public boolean canExecute() {
        if (this.preparationManager != null && this.changeRequest != null)
            return true;
        else
            return false;
    }

}
