package de.fzi.kamp.service.commands;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;

import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;

/**
 * Command to remove an architecture alternative. It is realized as a command, because this
 * operation causes a change in the analysis model, which should be saved.
 * 
 * @author tknapp
 * 
 */
public class RemoveArchiAltCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(RemoveArchiAltCommand.class);

    private ArchitecturalAlternative architectureAlternative;
    private MaintainabilityAnalysisModel analysisModel;

    /**
     * @param architectureAlternative
     *            The architecture alternative to remove.
     * @param analysisModel
     *            The underlying analysis model.
     */
    public RemoveArchiAltCommand(ArchitecturalAlternative architectureAlternative,
            MaintainabilityAnalysisModel analysisModel) {
        this.architectureAlternative = architectureAlternative;
        this.analysisModel = analysisModel;
    }

    /**
     * Removes the architecture alternative.
     */
    @Override
    public void execute() {
        this.analysisModel.getArchitecturealternatives().remove(architectureAlternative);
    }

    /**
     * Not implemented.
     */
    @Override
    public void redo() {
        // TODO Auto-generated method stub

    }

    /**
     * Tests whether all parameters are unequal to {@code null}.
     */
    @Override
    public boolean canExecute() {

        if (this.architectureAlternative != null)
            return true;
        else
            return false;
    }
}
