package de.fzi.kamp.service.commands;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.service.analysisinstance.impl.AnalysisInstanceManager;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;

/**
 * Command to remove an analysis instance. It is realized as a command, because this operation
 * causes a change in the analysis model, which should be saved.
 * 
 * @author tknapp
 * 
 */
public class RemoveAnalysisInstanceCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(RemoveAnalysisInstanceCommand.class);

    private AnalysisInstanceManager analysisInstanceManager;
    private EffortAnalysisInstance analysisInstance;
    private TableItem item;

    /**
     * @param analysisInstanceManager
     *            A manager to handle all actions concerning the analysis instances.
     * @param analysisInstance
     *            The current analysis instance to remove.
     * @param item
     *            The table item representing the analysis instance to remove.
     */
    public RemoveAnalysisInstanceCommand(AnalysisInstanceManager analysisInstanceManager,
            EffortAnalysisInstance analysisInstance, TableItem item) {
        this.analysisInstanceManager = analysisInstanceManager;
        this.analysisInstance = analysisInstance;
        this.item = item;
    }

    /**
     * Delegates the removal of the analysis instance to the analysis instance manager and disposes
     * the item.
     */
    @Override
    public void execute() {
        this.analysisInstanceManager.getAnalysisModel().getAnalysisinstances().remove(analysisInstance);
        this.item.dispose();
    }

    /**
     * Not implemented.
     */
    @Override
    public void redo() {
        // TODO Auto-generated method stub

    }

    /**
     * Tests whether all parameters are unequal to {@code null}.
     */
    @Override
    public boolean canExecute() {
        if (this.analysisInstanceManager != null && this.analysisInstance != null)
            return true;
        else
            return super.canExecute();
    }
}
