package de.fzi.kamp.service.commands;

import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;

import de.fzi.kamp.service.preparation.impl.PreparationManager;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;

/**
 * Command to load a new architecture alternative. It is realized as a command, because this
 * operation causes a change in the analysis model, which should be saved.
 * 
 * @author tknapp
 */
public class LoadArchiAltCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(LoadArchiAltCommand.class);

    private MaintainabilityAnalysisModel analysisModel;
    private List<AbstractArchitectureModel> selectedModels;
    private ArchitecturalAlternative alternative;
    private PreparationManager preparationManager;

    /**
     * 
     * @param architectureModelProvider
     *            A provider for the underlying architecture models.
     * @param dialogManager
     *            Manager to centralize handling of dialogs.
     * @param prepManager
     *            Manager to handle all actions occurring on the preparation page.
     * @param analysisModel
     *            The current analysis model.
     */
    public LoadArchiAltCommand(MaintainabilityAnalysisModel analysisModel,
            List<AbstractArchitectureModel> selectedModels, ArchitecturalAlternative alternative,
            PreparationManager preparationManager) {
        this.analysisModel = analysisModel;
        this.selectedModels = selectedModels;
        this.alternative = alternative;
        this.preparationManager = preparationManager;
    }

    /**
     * Gets a list of possible architecture models, creates a new architecture alternative instance
     * and and adds the selected model to the analysis model.
     */
    @Override
    public void execute() {
        for (AbstractArchitectureModel selected : selectedModels) {
            if (!alternativeExisting(selected)) {
                alternative.setArchitecturemodel(selected);
                analysisModel.getArchitecturealternatives().add(alternative);
            }
        }
    }

    /**
     * Tests whether an architecture alternative is already existing.
     * 
     * @param selected
     *            The selected architecture alternative.
     * @return <b>True</b> if already existing, else <b>false</b>.
     */
    private boolean alternativeExisting(AbstractArchitectureModel selected) {
        boolean exists = false;

        for (ArchitecturalAlternative alternativesThere : this.preparationManager.getArchitectureAlternatives()) {
            if (selected.getName().equals(alternativesThere.getName()))
                exists = true;
        }

        return exists;
    }

    /**
     * Not implemented.
     */
    @Override
    public void redo() {
        // TODO Auto-generated method stub
    }

    /**
     * Not implemented.
     */
    @Override
    public void undo() {
        logger.debug("This is the undo functionality, in the end.");
        super.undo();
    }

    /**
     * Tests whether all parameters are unequal to {@code null}.
     */
    @Override
    public boolean canExecute() {
        if (this.analysisModel != null)
            return true;
        else
            return false;
    }
}
